/*
 * Decompiled with CFR 0.152.
 */
package org.resthub.web.oauth2;

public class OAuth2Config {
    protected String username;
    protected String password;
    protected String clientId;
    protected String clientSecret;
    protected String accessTokenEndpoint;
    protected String refreshTokenEndpoint;
    protected String oauth2_scheme;

    public OAuth2Config(String username, String password, String clientId, String clientSecret, String accessTokenEndpoint, String refreshTokenEndpoint, String oauth2_scheme) {
        this.username = username;
        this.password = password;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.accessTokenEndpoint = accessTokenEndpoint;
        this.refreshTokenEndpoint = refreshTokenEndpoint;
        this.oauth2_scheme = oauth2_scheme;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public String getAccessTokenEndpoint() {
        return this.accessTokenEndpoint;
    }

    public String getRefreshTokenEndpoint() {
        return this.refreshTokenEndpoint;
    }

    public String getOAuth2Scheme() {
        return this.oauth2_scheme;
    }

    public static class Builder {
        private String oauth2_scheme = "Bearer";
        private String username;
        private String password;
        private String clientId;
        private String clientSecret;
        private String accessTokenEndpoint;
        private String refreshTokenEndpoint;

        public Builder setOAuth2Scheme(String oAuth2Scheme) {
            this.oauth2_scheme = oAuth2Scheme;
            return this;
        }

        public Builder setUsername(String username) {
            this.username = username;
            return this;
        }

        public Builder setPassword(String password) {
            this.password = password;
            return this;
        }

        public Builder setClientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public Builder setClientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        public Builder setAccessTokenEndpoint(String accessTokenEndpoint) {
            this.accessTokenEndpoint = accessTokenEndpoint;
            return this;
        }

        public Builder setRefreshTokenEndpoint(String refreshTokenEndpoint) {
            this.refreshTokenEndpoint = refreshTokenEndpoint;
            return this;
        }

        public OAuth2Config build() {
            return new OAuth2Config(this.username, this.password, this.clientId, this.clientSecret, this.accessTokenEndpoint, this.refreshTokenEndpoint, this.oauth2_scheme);
        }
    }
}

