/*
 * Decompiled with CFR 0.152.
 */
package org.resthub.web;

import com.fasterxml.jackson.core.type.TypeReference;
import com.ning.http.client.cookie.Cookie;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.resthub.web.support.BodyReader;

public class Response {
    private com.ning.http.client.Response ahcResponse;
    private List<BodyReader> bodyReaders = new ArrayList<BodyReader>();

    public Response(com.ning.http.client.Response ahcResponse) {
        this.ahcResponse = ahcResponse;
    }

    public void addBodyReader(BodyReader br) {
        this.bodyReaders.add(br);
    }

    public void addBodyReaders(List<BodyReader> bodyReaders) {
        this.bodyReaders.addAll(bodyReaders);
    }

    public <T> T resource(Class<T> type) {
        try {
            for (BodyReader br : this.bodyReaders) {
                if (!br.canRead(this.ahcResponse)) continue;
                return br.readEntity(this.ahcResponse, type);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        throw new RuntimeException("unsupported media type " + this.ahcResponse.getContentType());
    }

    public <T> T resource(Class<T> type, String charset) {
        try {
            for (BodyReader br : this.bodyReaders) {
                if (!br.canRead(this.ahcResponse)) continue;
                return br.readEntity(this.ahcResponse, type, charset);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        throw new RuntimeException("unsupported media type " + this.ahcResponse.getContentType());
    }

    public <T> T resource(TypeReference valueTypeRef) {
        try {
            for (BodyReader br : this.bodyReaders) {
                if (!br.canRead(this.ahcResponse)) continue;
                return br.readEntity(this.ahcResponse, valueTypeRef);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        throw new RuntimeException("unsupported media type " + this.ahcResponse.getContentType());
    }

    public <T> T resource(TypeReference valueTypeRef, String charset) {
        try {
            for (BodyReader br : this.bodyReaders) {
                if (!br.canRead(this.ahcResponse)) continue;
                return br.readEntity(this.ahcResponse, valueTypeRef, charset);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        throw new RuntimeException("unsupported media type " + this.ahcResponse.getContentType());
    }

    public int getStatus() {
        return this.ahcResponse.getStatusCode();
    }

    public String getHeader(String key) {
        return this.ahcResponse.getHeader(key);
    }

    public String getBody() {
        try {
            return this.ahcResponse.getResponseBody();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getBody(String charset) {
        try {
            return this.ahcResponse.getResponseBody(charset);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public List<Cookie> getCookies() {
        return this.ahcResponse.getCookies();
    }
}

