/*
 * Decompiled with CFR 0.152.
 */
package org.resthub.web;

import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.FluentStringsMap;
import com.ning.http.client.ProxyServer;
import com.ning.http.client.Realm;
import com.ning.http.client.RequestBuilderBase;
import com.ning.http.client.cookie.Cookie;
import com.ning.http.client.filter.RequestFilter;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.resthub.web.Response;
import org.resthub.web.exception.ClientException;
import org.resthub.web.exception.ClientExceptionFactory;
import org.resthub.web.oauth2.OAuth2Config;
import org.resthub.web.oauth2.OAuth2RequestFilter;
import org.resthub.web.support.AsyncEntityHandler;
import org.resthub.web.support.BodyReader;
import org.resthub.web.support.BodyWriter;
import org.resthub.web.support.JsonBodyReader;
import org.resthub.web.support.JsonBodyWriter;
import org.resthub.web.support.XmlBodyReader;
import org.resthub.web.support.XmlBodyWriter;

public class Client
implements Closeable {
    protected AsyncHttpClient client;
    protected AsyncHttpClientConfig.Builder builder;
    protected OAuth2Config.Builder oAuth2ConfigBuilder;
    protected OAuth2Config oAuth2Config;
    protected List<BodyReader> bodyReaders = new ArrayList<BodyReader>();
    protected List<BodyWriter> bodyWriters = new ArrayList<BodyWriter>();
    private String username = null;
    private String password = null;
    private Realm.AuthScheme scheme = null;

    public Client() {
        this.builder = new AsyncHttpClientConfig.Builder();
    }

    public Client(AsyncHttpClientConfig.Builder builder) {
        this.builder = builder;
    }

    public AsyncHttpClient getNativeClient() {
        return this.client;
    }

    public Client setProxy(String host, int port) {
        this.builder.setProxyServer(new ProxyServer(host, port));
        return this;
    }

    public Client addBodyReader(BodyReader br) {
        this.bodyReaders.add(br);
        return this;
    }

    public Client addBodyWriter(BodyWriter bw) {
        this.bodyWriters.add(bw);
        return this;
    }

    public Client setAuth(String username, String password, Realm.AuthScheme scheme) {
        this.username = username;
        this.password = password;
        this.scheme = scheme;
        return this;
    }

    public Client setOAuth2Builder(OAuth2Config.Builder builder) {
        this.oAuth2ConfigBuilder = builder;
        return this;
    }

    public Client setOAuth2(String username, String password, String accessTokenEndpoint, String clientId, String clientSecret) {
        if (null == this.oAuth2ConfigBuilder) {
            this.oAuth2ConfigBuilder = new OAuth2Config.Builder();
        }
        this.oAuth2ConfigBuilder.setUsername(username).setPassword(password);
        this.oAuth2ConfigBuilder.setAccessTokenEndpoint(accessTokenEndpoint);
        this.oAuth2ConfigBuilder.setClientId(clientId).setClientSecret(clientSecret);
        return this;
    }

    public RequestHolder url(String url) {
        if (this.client == null) {
            this.client = this.buildClient();
        }
        if (url.contains("?")) {
            throw new IllegalArgumentException("url should not contain query params; chain with setQueryParam() instead.");
        }
        this.bodyReaders.add(new JsonBodyReader());
        this.bodyReaders.add(new XmlBodyReader());
        this.bodyWriters.add(new JsonBodyWriter());
        this.bodyWriters.add(new XmlBodyWriter());
        return new RequestHolder(url);
    }

    @Override
    public void close() {
        if (this.client != null) {
            this.client.close();
        }
    }

    private AsyncHttpClient buildClient() {
        if (this.oAuth2ConfigBuilder != null) {
            this.oAuth2Config = this.oAuth2ConfigBuilder.build();
            OAuth2RequestFilter oauth2Filter = new OAuth2RequestFilter(this.oAuth2Config.getAccessTokenEndpoint(), this.oAuth2Config.getClientId(), this.oAuth2Config.getClientSecret());
            oauth2Filter.setCredentials(this.oAuth2Config.getUsername(), this.oAuth2Config.getPassword());
            oauth2Filter.setSchemeName(this.oAuth2Config.getOAuth2Scheme());
            this.builder.addRequestFilter((RequestFilter)oauth2Filter);
        }
        return new AsyncHttpClient(this.builder.build());
    }

    public class RequestHolder {
        private final String url;
        private Map<String, Collection<String>> headers = new HashMap<String, Collection<String>>();
        private Map<String, Collection<String>> queryParameters = new HashMap<String, Collection<String>>();
        private List<Cookie> cookies = new ArrayList<Cookie>();
        private String body = null;
        private String charset = "UTF-8";

        public RequestHolder(String url) {
            this.url = url;
        }

        public RequestHolder setHeader(String name, String value) {
            if (this.headers.containsKey(name)) {
                Collection<String> values = this.headers.get(name);
                values.add(value);
            } else {
                ArrayList<String> values = new ArrayList<String>();
                values.add(value);
                this.headers.put(name, values);
            }
            return this;
        }

        public RequestHolder setQueryParameter(String name, String value) {
            if (this.queryParameters.containsKey(name)) {
                Collection<String> values = this.queryParameters.get(name);
                values.add(value);
            } else {
                ArrayList<String> values = new ArrayList<String>();
                values.add(value);
                this.queryParameters.put(name, values);
            }
            return this;
        }

        public RequestHolder setBodyEncoding(String charset) {
            this.charset = charset;
            return this;
        }

        public RequestHolder addCookie(Cookie cookie) {
            this.cookies.add(cookie);
            return this;
        }

        public Future<Response> asyncGet() {
            return this.execute("GET");
        }

        public Future<Response> asyncJsonGet() {
            this.setHeader("Accept", "application/json");
            return this.execute("GET");
        }

        public Future<Response> asyncXmlGet() {
            this.setHeader("Accept", "application/xml");
            return this.execute("GET");
        }

        public Response get() {
            return this.executeSync("GET");
        }

        public Response jsonGet() {
            this.setHeader("Accept", "application/json");
            return this.executeSync("GET");
        }

        public Response xmlGet() {
            this.setHeader("Accept", "application/xml");
            return this.executeSync("GET");
        }

        public Future<Response> asyncPost(String body) {
            return this.executeString("POST", body);
        }

        public Future<Response> asyncPost() {
            return this.executeString("POST", this.body);
        }

        public Future<Response> asyncPost(InputStream body) {
            return this.executeIS("POST", body);
        }

        public Future<Response> asyncPost(File body) {
            return this.executeFile("POST", body);
        }

        public Future<Response> asyncJsonPost(Object o) {
            this.setHeader("Accept", "application/json");
            this.setHeader("Content-Type", "application/json");
            return this.executeString("POST", this.serialize("application/json", o));
        }

        public Future<Response> asyncXmlPost(Object o) {
            this.setHeader("Accept", "application/xml");
            this.setHeader("Content-Type", "application/xml");
            return this.executeString("POST", this.serialize("application/xml", o));
        }

        public Response post(String body) {
            return this.executeStringSync("POST", body);
        }

        public Response post() {
            return this.executeStringSync("POST", this.body);
        }

        public Response post(InputStream body) {
            return this.executeISSync("POST", body);
        }

        public Response post(File body) {
            return this.executeFileSync("POST", body);
        }

        public Response jsonPost(Object o) {
            this.setHeader("Accept", "application/json");
            this.setHeader("Content-Type", "application/json");
            return this.executeStringSync("POST", this.serialize("application/json", o));
        }

        public Response xmlPost(Object o) {
            this.setHeader("Accept", "application/xml");
            this.setHeader("Content-Type", "application/xml");
            return this.executeStringSync("POST", this.serialize("application/xml", o));
        }

        public Future<Response> asyncPut(String body) {
            return this.executeString("PUT", body);
        }

        public Future<Response> asyncPut(InputStream body) {
            return this.executeIS("PUT", body);
        }

        public Future<Response> asyncPut(File body) {
            return this.executeFile("PUT", body);
        }

        public Future<Response> asyncJsonPut(Object o) {
            this.setHeader("Accept", "application/json");
            this.setHeader("Content-Type", "application/json");
            return this.executeString("PUT", this.serialize("application/json", o));
        }

        public Future<Response> asyncXmlPut(Object o) {
            this.setHeader("Accept", "application/xml");
            this.setHeader("Content-Type", "application/xml");
            return this.executeString("PUT", this.serialize("application/xml", o));
        }

        public Response put(String body) {
            return this.executeStringSync("PUT", body);
        }

        public Response put(InputStream body) {
            return this.executeISSync("PUT", body);
        }

        public Response put(File body) {
            return this.executeFileSync("PUT", body);
        }

        public Response jsonPut(Object o) {
            this.setHeader("Accept", "application/json");
            this.setHeader("Content-Type", "application/json");
            return this.executeStringSync("PUT", this.serialize("application/json", o));
        }

        public Response xmlPut(Object o) {
            this.setHeader("Accept", "application/xml");
            this.setHeader("Content-Type", "application/xml");
            return this.executeStringSync("PUT", this.serialize("application/xml", o));
        }

        public Future<Response> asyncDelete() {
            return this.execute("DELETE");
        }

        public Response delete() {
            return this.executeSync("DELETE");
        }

        public Future<Response> asyncHead() {
            return this.execute("HEAD");
        }

        public Response head() {
            return this.executeSync("HEAD");
        }

        public Future<Response> asyncOption() {
            return this.execute("OPTION");
        }

        public Response option() {
            return this.executeSync("OPTION");
        }

        private Response executeSync(String method) {
            Response response = null;
            try {
                response = this.execute(method).get();
            }
            catch (InterruptedException e) {
                throw new ClientException((Throwable)e);
            }
            catch (ExecutionException e) {
                throw new ClientException((Throwable)e);
            }
            if (response.getStatus() >= 400) {
                throw ClientExceptionFactory.createHttpExceptionFromStatusCode((int)response.getStatus());
            }
            return response;
        }

        private Future<Response> execute(String method) {
            Request req = (Request)((Request)((Request)new Request(method).setUrl(this.url)).setHeaders(this.headers)).setQueryParameters(new FluentStringsMap(this.queryParameters));
            if (Client.this.username != null && Client.this.password != null && Client.this.scheme != null) {
                req.auth(Client.this.username, Client.this.password, Client.this.scheme);
            }
            if (Client.this.oAuth2Config != null && Client.this.oAuth2Config.getAccessTokenEndpoint() != null) {
                req.setRealm(new Realm.RealmBuilder().setPrincipal(Client.this.oAuth2Config.getUsername()).setPassword(Client.this.oAuth2Config.getPassword()).build());
            }
            this.addCookies(req);
            return req.execute();
        }

        private Response executeStringSync(String method, String body) {
            Response response = null;
            try {
                response = this.executeString(method, body).get();
            }
            catch (InterruptedException e) {
                throw new ClientException((Throwable)e);
            }
            catch (ExecutionException e) {
                throw new ClientException((Throwable)e);
            }
            if (response.getStatus() >= 400) {
                throw ClientExceptionFactory.createHttpExceptionFromStatusCode((int)response.getStatus());
            }
            return response;
        }

        private Future<Response> executeString(String method, String body) {
            Request req = (Request)((Request)((Request)((Request)((Request)new Request(method).setBodyEncoding(this.charset)).setBody(body)).setUrl(this.url)).setHeaders(this.headers)).setQueryParameters(new FluentStringsMap(this.queryParameters));
            if (Client.this.username != null && Client.this.password != null && Client.this.scheme != null) {
                req.auth(Client.this.username, Client.this.password, Client.this.scheme);
            }
            this.addCookies(req);
            return req.execute();
        }

        private Response executeISSync(String method, InputStream body) {
            Response response = null;
            try {
                response = this.executeIS(method, body).get();
            }
            catch (InterruptedException e) {
                throw new ClientException((Throwable)e);
            }
            catch (ExecutionException e) {
                throw new ClientException((Throwable)e);
            }
            if (response.getStatus() >= 400) {
                throw ClientExceptionFactory.createHttpExceptionFromStatusCode((int)response.getStatus());
            }
            return response;
        }

        private Future<Response> executeIS(String method, InputStream body) {
            Request req = (Request)((Request)((Request)((Request)((Request)new Request(method).setBodyEncoding(this.charset)).setBody(body)).setUrl(this.url)).setHeaders(this.headers)).setQueryParameters(new FluentStringsMap(this.queryParameters));
            if (Client.this.username != null && Client.this.password != null && Client.this.scheme != null) {
                req.auth(Client.this.username, Client.this.password, Client.this.scheme);
            }
            this.addCookies(req);
            return req.execute();
        }

        private Response executeFileSync(String method, File body) {
            Response response = null;
            try {
                response = this.executeFile(method, body).get();
            }
            catch (ExecutionException e) {
                throw new ClientException((Throwable)e);
            }
            catch (InterruptedException e) {
                throw new ClientException((Throwable)e);
            }
            if (response.getStatus() >= 400) {
                throw ClientExceptionFactory.createHttpExceptionFromStatusCode((int)response.getStatus());
            }
            return response;
        }

        private Future<Response> executeFile(String method, File body) {
            Request req = (Request)((Request)((Request)((Request)((Request)new Request(method).setBodyEncoding(this.charset)).setBody(body)).setUrl(this.url)).setHeaders(this.headers)).setQueryParameters(new FluentStringsMap(this.queryParameters));
            if (Client.this.username != null && Client.this.password != null && Client.this.scheme != null) {
                req.auth(Client.this.username, Client.this.password, Client.this.scheme);
            }
            this.addCookies(req);
            return req.execute();
        }

        private void addCookies(Request req) {
            for (Cookie cookie : this.cookies) {
                req.addCookie(cookie);
            }
        }

        private String serialize(String mediaType, Object o) {
            for (BodyWriter bw : Client.this.bodyWriters) {
                if (!bw.canWrite(mediaType)) continue;
                return bw.writeEntity(mediaType, o);
            }
            throw new RuntimeException("cannot serialize request body for mediaType " + mediaType);
        }
    }

    public class Request
    extends RequestBuilderBase<Request> {
        public Request(String method) {
            super(Request.class, method, false);
        }

        private Request auth(String username, String password, Realm.AuthScheme scheme) {
            this.setRealm(new Realm.RealmBuilder().setScheme(scheme).setPrincipal(username).setPassword(password).setUsePreemptiveAuth(true).build());
            return this;
        }

        private Future<Response> execute() {
            Future future = null;
            AsyncEntityHandler handler = new AsyncEntityHandler();
            handler.setBodyReaders(Client.this.bodyReaders);
            try {
                future = Client.this.client.executeRequest((com.ning.http.client.Request)this.request, (AsyncHandler)handler);
            }
            catch (IOException ex) {
                future.cancel(true);
            }
            return future;
        }
    }
}

