/*
 * Decompiled with CFR 0.152.
 */
package org.resthub.web.support;

import com.fasterxml.jackson.core.type.TypeReference;
import com.ning.http.client.Response;
import java.io.IOException;
import org.resthub.web.JsonHelper;
import org.resthub.web.support.BodyReader;

public class JsonBodyReader
implements BodyReader {
    @Override
    public boolean canRead(Response response) {
        return response.getContentType() != null && (response.getContentType().startsWith("application/json") || response.getContentType().endsWith("+json"));
    }

    @Override
    public <T> T readEntity(Response resp, Class<T> entityClass) throws IOException {
        return (T)JsonHelper.deserialize((String)resp.getResponseBody(), entityClass);
    }

    @Override
    public <T> T readEntity(Response resp, Class<T> entityClass, String charset) throws IOException {
        return (T)JsonHelper.deserialize((String)resp.getResponseBody(charset), entityClass);
    }

    @Override
    public <T> T readEntity(Response resp, TypeReference valueTypeRef) throws IOException {
        return (T)JsonHelper.deserialize((String)resp.getResponseBody(), (TypeReference)valueTypeRef);
    }

    @Override
    public <T> T readEntity(Response resp, TypeReference valueTypeRef, String charset) throws IOException {
        return (T)JsonHelper.deserialize((String)resp.getResponseBody(charset), (TypeReference)valueTypeRef);
    }
}

