/*
 * Decompiled with CFR 0.152.
 */
package org.resthub.web.oauth2;

import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.Response;
import com.ning.http.client.filter.FilterContext;
import com.ning.http.client.filter.FilterException;
import com.ning.http.client.filter.RequestFilter;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.resthub.web.JsonHelper;
import org.resthub.web.exception.SerializationException;
import org.resthub.web.oauth2.OAuth2Token;

public class OAuth2RequestFilter
implements RequestFilter {
    public static final String GRANT_TYPE_PARAMETER_NAME = "grant_type";
    public static final String CLIENT_ID_PARAMETER_NAME = "client_id";
    public static final String CLIENT_SECRET_PARAMETER_NAME = "client_secret";
    public static final String USERNAME_PARAMETER_NAME = "username";
    public static final String PASSWORD_PARAMETER_NAME = "password";
    public static final String SCOPE_PARAMETER_NAME = "scope";
    public static final String PASSWORD_PARAMETER_VALUE = "password";
    protected String accessTokenEndPoint;
    protected String clientId;
    protected String clientSecret;
    protected String scheme_name;
    protected String username;
    protected String password;
    protected long acquireTime;
    protected OAuth2Token token;

    public OAuth2RequestFilter(String accessTokenEndPoint, String clientId, String clientSecret) {
        this.accessTokenEndPoint = accessTokenEndPoint;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.token = null;
    }

    public void setCredentials(String username, String password) {
        this.username = username;
        this.password = password;
    }

    public String getAccessTokenEndPoint() {
        return this.accessTokenEndPoint;
    }

    public void setAccessTokenEndPoint(String accessTokenEndPoint) {
        this.accessTokenEndPoint = accessTokenEndPoint;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public String getSchemeName() {
        return this.scheme_name;
    }

    public void setSchemeName(String scheme_name) {
        this.scheme_name = scheme_name;
    }

    private OAuth2Token retrieveAccessToken(String username, String password) {
        OAuth2Token token;
        AsyncHttpClient client = new AsyncHttpClient();
        AsyncHttpClient.BoundRequestBuilder request = client.preparePost(this.accessTokenEndPoint);
        request.setHeader("Content-Type", "application/x-www-form-urlencoded");
        request.setHeader("Accept", "application/json");
        request.addParameter(GRANT_TYPE_PARAMETER_NAME, "password");
        request.addParameter(CLIENT_ID_PARAMETER_NAME, this.clientId);
        request.addParameter(CLIENT_SECRET_PARAMETER_NAME, this.clientSecret);
        request.addParameter(USERNAME_PARAMETER_NAME, username);
        request.addParameter("password", password);
        try {
            Response response = (Response)request.execute().get();
            token = (OAuth2Token)JsonHelper.deserialize((String)response.getResponseBody("UTF-8"), OAuth2Token.class);
            this.acquireTime = TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis());
        }
        catch (InterruptedException e) {
            throw new SerializationException((Throwable)e);
        }
        catch (ExecutionException e) {
            throw new SerializationException((Throwable)e);
        }
        catch (IOException e) {
            throw new SerializationException((Throwable)e);
        }
        return token;
    }

    private boolean isTokenExpired() {
        return TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis()) - this.acquireTime > (long)(this.token.getExpiresIn() - 5);
    }

    public FilterContext filter(FilterContext ctx) throws FilterException {
        if (this.token == null || this.isTokenExpired()) {
            this.token = this.retrieveAccessToken(this.username, this.password);
        }
        ctx.getRequest().getHeaders().add("Authorization", this.scheme_name + " " + this.token.getAccessToken());
        return ctx;
    }
}

