/*
 * Decompiled with CFR 0.152.
 */
package org.resthub.web.exception;

import org.resthub.web.exception.BadRequestClientException;
import org.resthub.web.exception.ClientException;
import org.resthub.web.exception.ConflictClientException;
import org.resthub.web.exception.ForbiddenClientException;
import org.resthub.web.exception.InternalServerErrorClientException;
import org.resthub.web.exception.NotAcceptableClientException;
import org.resthub.web.exception.NotFoundClientException;
import org.resthub.web.exception.NotImplementedClientException;
import org.resthub.web.exception.UnauthorizedClientException;

public class ClientExceptionFactory {
    public static ClientException createHttpExceptionFromStatusCode(int statusCode) {
        return ClientExceptionFactory.createHttpExceptionFromStatusCode(statusCode, "");
    }

    public static ClientException createHttpExceptionFromStatusCode(int statusCode, String message) {
        switch (statusCode) {
            case 400: {
                return new BadRequestClientException(message);
            }
            case 409: {
                return new ConflictClientException(message);
            }
            case 500: {
                return new InternalServerErrorClientException(message);
            }
            case 404: {
                return new NotFoundClientException(message);
            }
            case 501: {
                return new NotImplementedClientException(message);
            }
            case 401: {
                return new UnauthorizedClientException(message);
            }
            case 403: {
                return new ForbiddenClientException(message);
            }
            case 406: {
                return new NotAcceptableClientException(message);
            }
        }
        if (statusCode >= 400 && statusCode <= 599) {
            return new ClientException(statusCode, message);
        }
        throw new IllegalArgumentException("Status code " + statusCode + " is not an HTTP error code");
    }
}

