/*
 * Decompiled with CFR 0.152.
 */
package org.resthub.web;

import java.io.IOException;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.bind.ValidationException;
import org.resthub.common.exception.NotFoundException;
import org.resthub.common.exception.NotImplementedException;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.AbstractHandlerExceptionResolver;

@Named(value="resthubHandlerExceptionResolver")
public class ResthubHandlerExceptionResolver
extends AbstractHandlerExceptionResolver {
    protected ModelAndView doResolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        try {
            if (ex instanceof IllegalArgumentException) {
                return this.handleIllegalArgument((IllegalArgumentException)ex, request, response, handler);
            }
            if (ex instanceof ValidationException) {
                return this.handleValidation((ValidationException)ex, request, response, handler);
            }
            if (ex instanceof NotFoundException) {
                return this.handleNotFound((NotFoundException)ex, request, response, handler);
            }
            if (ex instanceof NotImplementedException) {
                return this.handleNotImplemented((NotImplementedException)ex, request, response, handler);
            }
        }
        catch (Exception handlerException) {
            this.logger.error((Object)("Handling of [" + ex.getClass().getName() + "] resulted in Exception"), (Throwable)handlerException);
        }
        return null;
    }

    protected ModelAndView handleIllegalArgument(IllegalArgumentException ex, HttpServletRequest request, HttpServletResponse response, Object handler) throws IOException {
        response.sendError(400);
        return new ModelAndView();
    }

    protected ModelAndView handleValidation(ValidationException ex, HttpServletRequest request, HttpServletResponse response, Object handler) throws IOException {
        response.sendError(400);
        return new ModelAndView();
    }

    protected ModelAndView handleNotFound(NotFoundException ex, HttpServletRequest request, HttpServletResponse response, Object handler) throws IOException {
        response.sendError(404);
        return new ModelAndView();
    }

    protected ModelAndView handleNotImplemented(NotImplementedException ex, HttpServletRequest request, HttpServletResponse response, Object handler) throws IOException {
        response.sendError(501);
        return new ModelAndView();
    }
}

