/*
 * Decompiled with CFR 0.152.
 */
package org.resthub.web.controller;

import java.io.Serializable;
import org.resthub.common.exception.NotFoundException;
import org.resthub.common.exception.NotImplementedException;
import org.resthub.common.service.CrudService;
import org.resthub.web.controller.RestController;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

public abstract class ServiceBasedRestController<T, ID extends Serializable, S extends CrudService>
implements RestController<T, ID> {
    protected S service;

    public void setService(S service) {
        this.service = service;
    }

    @Override
    public T create(@RequestBody T resource) {
        return (T)this.service.create(resource);
    }

    @Override
    public T update(@PathVariable ID id, @RequestBody T resource) {
        Assert.notNull(id, (String)"id cannot be null");
        T retreivedResource = this.findById(id);
        if (retreivedResource == null) {
            throw new NotFoundException();
        }
        return (T)this.service.update(resource);
    }

    @Override
    public Iterable<T> findAllXml() {
        throw new NotImplementedException("XML findAll() is currently not implemented");
    }

    @Override
    public Iterable<T> findAll() {
        return this.service.findAll();
    }

    @Override
    public Page<T> findPaginated(@RequestParam(value="page", required=false, defaultValue="1") Integer page, @RequestParam(value="size", required=false, defaultValue="10") Integer size, @RequestParam(value="direction", required=false, defaultValue="") String direction, @RequestParam(value="properties", required=false) String properties) {
        Assert.isTrue((page > 0 ? 1 : 0) != 0, (String)"Page index must be greater than 0");
        Assert.isTrue((direction.isEmpty() || direction.equalsIgnoreCase(Sort.Direction.ASC.toString()) || direction.equalsIgnoreCase(Sort.Direction.DESC.toString()) ? 1 : 0) != 0, (String)"Direction should be ASC or DESC");
        if (direction.isEmpty()) {
            return this.service.findAll((Pageable)new PageRequest(page - 1, size.intValue()));
        }
        Assert.notNull((Object)properties);
        return this.service.findAll((Pageable)new PageRequest(page - 1, size.intValue(), new Sort(Sort.Direction.fromString((String)direction.toUpperCase()), properties.split(","))));
    }

    @Override
    public T findById(@PathVariable ID id) {
        Object resource = this.service.findById(id);
        if (resource == null) {
            throw new NotFoundException();
        }
        return (T)resource;
    }

    @Override
    public void delete() {
        this.service.deleteAllWithCascade();
    }

    @Override
    public void delete(@PathVariable ID id) {
        T resource = this.findById(id);
        this.service.delete(resource);
    }
}

