/*
 * Decompiled with CFR 0.152.
 */
package org.resthub.web.validation;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.inject.Named;
import javax.validation.MessageInterpolator;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.metadata.BeanDescriptor;
import javax.validation.metadata.ConstraintDescriptor;
import javax.validation.metadata.PropertyDescriptor;
import org.resthub.web.validation.ModelConstraint;
import org.resthub.web.validation.ValidationConstraint;
import org.resthub.web.validation.ValidationContext;
import org.resthub.web.validation.ValidationService;
import org.springframework.context.annotation.Profile;

@Profile(value={"resthub-validation"})
@Named(value="validationService")
public class ValidationServiceImpl
implements ValidationService {
    private static final ValidatorFactory FACTORY = Validation.buildDefaultValidatorFactory();
    private static final Validator VALIDATOR = FACTORY.getValidator();

    @Override
    public ModelConstraint getConstraintsForClassName(String canonicalClassName) throws ClassNotFoundException {
        return this.getConstraintsForClassName(canonicalClassName, null);
    }

    @Override
    public ModelConstraint getConstraintsForClassName(String canonicalClassName, Locale locale) throws ClassNotFoundException {
        return this.getConstraintsForClass(Class.forName(canonicalClassName), locale);
    }

    @Override
    public ModelConstraint getConstraintsForClass(Class<?> clazz) {
        return this.getConstraintsForClass(clazz, null);
    }

    @Override
    public ModelConstraint getConstraintsForClass(Class<?> clazz, Locale locale) {
        ModelConstraint modelConstraint = null;
        BeanDescriptor bd = VALIDATOR.getConstraintsForClass(clazz);
        if (bd.isBeanConstrained() && !Modifier.isAbstract(clazz.getModifiers())) {
            modelConstraint = new ModelConstraint(clazz.getCanonicalName());
            modelConstraint.setConstraints(this.getConstraints(bd, locale));
        }
        return modelConstraint;
    }

    private Map<String, List<ValidationConstraint>> getConstraints(BeanDescriptor bd, Locale locale) {
        HashMap<String, List<ValidationConstraint>> constraints = new HashMap<String, List<ValidationConstraint>>();
        for (PropertyDescriptor pd : bd.getConstrainedProperties()) {
            if (pd.getPropertyName() == null || !pd.hasConstraints() && !pd.isCascaded()) continue;
            constraints.put(pd.getPropertyName(), this.getValidationConstraints(pd, locale));
        }
        return constraints;
    }

    private List<ValidationConstraint> getValidationConstraints(PropertyDescriptor pd, Locale locale) {
        ArrayList<ValidationConstraint> validationConstraints = new ArrayList<ValidationConstraint>();
        for (ConstraintDescriptor cd : pd.getConstraintDescriptors()) {
            ValidationConstraint validationConstraint = new ValidationConstraint();
            validationConstraint.setType(this.getType(cd));
            validationConstraint.setMessage(this.getMessage(cd, locale));
            validationConstraint.setAttributes(this.getAttributes(cd));
            validationConstraints.add(validationConstraint);
        }
        if (pd.isCascaded()) {
            ValidationConstraint validationConstraint = new ValidationConstraint();
            validationConstraint.setType("Valid");
            validationConstraint.addAttribute("model", pd.getElementClass().getCanonicalName());
            validationConstraints.add(validationConstraint);
        }
        return validationConstraints;
    }

    private String getType(ConstraintDescriptor cd) {
        String type = cd.getAnnotation().annotationType().toString();
        return type.substring(type.lastIndexOf(46) + 1, type.length());
    }

    private String getMessage(ConstraintDescriptor cd, Locale locale) {
        String msgKey = cd.getAttributes().get("message").toString();
        ValidationContext validationContext = new ValidationContext(cd, null);
        String msg = null == locale ? FACTORY.getMessageInterpolator().interpolate(msgKey, (MessageInterpolator.Context)validationContext) : FACTORY.getMessageInterpolator().interpolate(msgKey, (MessageInterpolator.Context)validationContext, locale);
        return msg.replaceAll("[{}]", "");
    }

    private Map<String, Object> getAttributes(ConstraintDescriptor cd) {
        HashMap<String, Object> attributes = new HashMap<String, Object>(cd.getAttributes());
        attributes.remove("payload");
        attributes.remove("groups");
        attributes.remove("message");
        return attributes;
    }
}

