/*
 * Decompiled with CFR 0.152.
 */
package org.resthub.web.view;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Named;
import org.resthub.web.view.ViewInjectingReturnValueHandler;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.web.method.support.HandlerMethodReturnValueHandler;
import org.springframework.web.method.support.HandlerMethodReturnValueHandlerComposite;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter;
import org.springframework.web.servlet.mvc.method.annotation.RequestResponseBodyMethodProcessor;

@Named(value="jsonViewSupportFactoryBean")
@Profile(value={"resthub-web-server"})
public class JsonViewSupportFactoryBean
implements InitializingBean {
    @Autowired
    private RequestMappingHandlerAdapter adapter;

    public void afterPropertiesSet() throws Exception {
        HandlerMethodReturnValueHandlerComposite returnValueHandlers = this.adapter.getReturnValueHandlers();
        ArrayList<HandlerMethodReturnValueHandler> handlers = new ArrayList<HandlerMethodReturnValueHandler>(returnValueHandlers.getHandlers());
        this.decorateHandlers(handlers);
        this.adapter.setReturnValueHandlers(handlers);
    }

    private void decorateHandlers(List<HandlerMethodReturnValueHandler> handlers) {
        for (HandlerMethodReturnValueHandler handler : handlers) {
            if (!(handler instanceof RequestResponseBodyMethodProcessor)) continue;
            ViewInjectingReturnValueHandler decorator = new ViewInjectingReturnValueHandler(handler);
            int index = handlers.indexOf(handler);
            handlers.set(index, decorator);
            break;
        }
    }
}

