/*
 * Decompiled with CFR 0.152.
 */
package org.resthub.web.log;

import java.text.SimpleDateFormat;
import javax.inject.Named;
import org.resthub.web.log.Log;
import org.resthub.web.log.LogStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Profile;

@Named(value="defaultLogStrategy")
@Profile(value={"resthub-client-logging"})
public class DefaultLogStrategy
implements LogStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"JSLogger");
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("dd/MM/yy HH:mm:ss");

    @Override
    public void logError(Log log) {
        LOGGER.error("[{}] {} {}", new Object[]{log.browser, DATE_FORMAT.format(log.time), log.message});
    }

    @Override
    public void logWarn(Log log) {
        LOGGER.warn("[{}] {} {}", new Object[]{log.browser, DATE_FORMAT.format(log.time), log.message});
    }

    @Override
    public void logInfo(Log log) {
        LOGGER.info("[{}] {} {}", new Object[]{log.browser, DATE_FORMAT.format(log.time), log.message});
    }

    @Override
    public void logDebug(Log log) {
        LOGGER.debug("[{}] {} {}", new Object[]{log.browser, DATE_FORMAT.format(log.time), log.message});
    }
}

