/*
 * Decompiled with CFR 0.152.
 */
package org.resthub.web.converter;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import com.fasterxml.jackson.dataformat.xml.JacksonXmlModule;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import java.io.IOException;
import java.nio.charset.Charset;
import org.resthub.common.view.DataView;
import org.resthub.web.converter.ResthubPageModule;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.AbstractHttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.util.Assert;

public class MappingJackson2XmlHttpMessageConverter
extends AbstractHttpMessageConverter<Object> {
    public static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");
    private ObjectMapper objectMapper;
    private Boolean prettyPrint;

    public MappingJackson2XmlHttpMessageConverter() {
        super(new MediaType("application", "xml", DEFAULT_CHARSET));
        JacksonXmlModule xmlModule = new JacksonXmlModule();
        xmlModule.setDefaultUseWrapper(false);
        this.objectMapper = new XmlMapper(xmlModule);
        this.objectMapper.registerModule((Module)new ResthubPageModule());
        JacksonAnnotationIntrospector introspector = new JacksonAnnotationIntrospector();
        this.objectMapper.setAnnotationIntrospector((AnnotationIntrospector)introspector);
        this.objectMapper.configure(MapperFeature.DEFAULT_VIEW_INCLUSION, false);
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        Assert.notNull((Object)objectMapper, (String)"ObjectMapper must not be null");
        this.objectMapper = objectMapper;
        this.configurePrettyPrint();
    }

    private void configurePrettyPrint() {
        if (this.prettyPrint != null) {
            this.objectMapper.configure(SerializationFeature.INDENT_OUTPUT, this.prettyPrint.booleanValue());
        }
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
        this.configurePrettyPrint();
    }

    public boolean canRead(Class<?> clazz, MediaType mediaType) {
        JavaType javaType = this.getJavaType(clazz);
        return this.objectMapper.canDeserialize(javaType) && this.canRead(mediaType);
    }

    public boolean canWrite(Class<?> clazz, MediaType mediaType) {
        return this.objectMapper.canSerialize(clazz) && this.canWrite(mediaType);
    }

    protected boolean supports(Class<?> clazz) {
        throw new UnsupportedOperationException();
    }

    protected Object readInternal(Class<?> clazz, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        JavaType javaType = this.getJavaType(clazz);
        try {
            return this.objectMapper.readValue(inputMessage.getBody(), javaType);
        }
        catch (IOException ex) {
            throw new HttpMessageNotReadableException("Could not read XML: " + ex.getMessage(), (Throwable)ex);
        }
    }

    protected void writeInternal(Object object, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        JsonEncoding encoding = this.getJsonEncoding(outputMessage.getHeaders().getContentType());
        JsonGenerator jsonGenerator = this.objectMapper.getFactory().createGenerator(outputMessage.getBody(), encoding);
        try {
            if (object instanceof DataView && ((DataView)object).hasView()) {
                ObjectWriter writer = this.objectMapper.writerWithView(((DataView)object).getView());
                writer.writeValue(jsonGenerator, ((DataView)object).getData());
            } else {
                this.objectMapper.writeValue(jsonGenerator, object);
            }
        }
        catch (JsonProcessingException ex) {
            throw new HttpMessageNotWritableException("Could not write XML: " + ex.getMessage(), (Throwable)ex);
        }
    }

    protected JavaType getJavaType(Class<?> clazz) {
        return this.objectMapper.constructType(clazz);
    }

    protected JsonEncoding getJsonEncoding(MediaType contentType) {
        if (contentType != null && contentType.getCharSet() != null) {
            Charset charset = contentType.getCharSet();
            for (JsonEncoding encoding : JsonEncoding.values()) {
                if (!charset.name().equals(encoding.getJavaName())) continue;
                return encoding;
            }
        }
        return JsonEncoding.UTF8;
    }
}

