/*
 * Decompiled with CFR 0.152.
 */
package org.resthub.web.controller;

import javax.inject.Inject;
import javax.inject.Named;
import org.resthub.web.log.Log;
import org.resthub.web.log.LogStrategy;
import org.resthub.web.log.Logs;
import org.springframework.context.annotation.Profile;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
@Profile(value={"resthub-client-logging"})
public class LogController {
    private LogStrategy logStrategy;

    @Inject
    @Named(value="defaultLogStrategy")
    public void setLogStrategy(LogStrategy logStrategy) {
        this.logStrategy = logStrategy;
    }

    @RequestMapping(value={"api/log"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.OK)
    public void logAction(@RequestBody Log log, @RequestHeader(value="User-Agent") String userAgent) {
        log.browser = userAgent;
        switch (log.level) {
            case debug: {
                this.logStrategy.logDebug(log);
                break;
            }
            case info: {
                this.logStrategy.logInfo(log);
                break;
            }
            case warn: {
                this.logStrategy.logWarn(log);
                break;
            }
            case error: {
                this.logStrategy.logError(log);
                break;
            }
        }
    }

    @RequestMapping(value={"api/logs"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.OK)
    public void log(@RequestBody Logs logs, @RequestHeader(value="User-Agent") String userAgent) {
        for (Log log : logs) {
            this.logAction(log, userAgent);
        }
    }
}

