/*
 * Decompiled with CFR 0.152.
 */
package org.resthub.web.validation;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.resthub.web.validation.ValidationConstraint;

@JsonPropertyOrder(value={"model", "constraints"})
public class ModelConstraint {
    private String modelRef;
    private Map<String, List<ValidationConstraint>> constraints;

    @JsonCreator
    public ModelConstraint(@JsonProperty(value="model") String modelRef) {
        this.modelRef = modelRef;
        this.constraints = new HashMap<String, List<ValidationConstraint>>();
    }

    @JsonProperty(value="model")
    public String getModelRef() {
        return this.modelRef;
    }

    public void setModelRef(String modelRef) {
        this.modelRef = modelRef;
    }

    public Map<String, List<ValidationConstraint>> getConstraints() {
        return this.constraints;
    }

    public void setConstraints(Map<String, List<ValidationConstraint>> constraints) {
        this.constraints = constraints;
    }

    public List<ValidationConstraint> addConstraint(String property, ValidationConstraint constraint) {
        List<ValidationConstraint> propertyConstraints;
        if (null == this.constraints) {
            this.constraints = new HashMap<String, List<ValidationConstraint>>();
        }
        if (null == (propertyConstraints = this.constraints.get(property))) {
            propertyConstraints = new ArrayList<ValidationConstraint>();
        }
        propertyConstraints.add(constraint);
        return this.constraints.put(property, propertyConstraints);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ModelConstraint)) {
            return false;
        }
        ModelConstraint that = (ModelConstraint)o;
        return !(this.modelRef != null ? !this.modelRef.equals(that.modelRef) : that.modelRef != null);
    }

    public int hashCode() {
        return this.modelRef != null ? this.modelRef.hashCode() : 0;
    }
}

