/*
 * Decompiled with CFR 0.152.
 */
package org.resthub.rpc;

import com.caucho.hessian.client.HessianRuntimeException;
import com.caucho.hessian.io.AbstractHessianInput;
import com.caucho.hessian.io.AbstractHessianOutput;
import com.caucho.hessian.io.HessianProtocolException;
import com.caucho.services.server.AbstractSkeleton;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.concurrent.TimeoutException;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.resthub.rpc.AMQPHessianProxyFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;

public class AMQPHessianProxy
implements InvocationHandler {
    private AMQPHessianProxyFactory _factory;

    AMQPHessianProxy() {
    }

    AMQPHessianProxy(AMQPHessianProxyFactory factory) {
        this._factory = factory;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        Class<?>[] params = method.getParameterTypes();
        if (methodName.equals("equals") && params.length == 1 && params[0].equals(Object.class)) {
            Object value = args[0];
            if (value == null || !Proxy.isProxyClass(value.getClass())) {
                return Boolean.FALSE;
            }
            AMQPHessianProxy handler = (AMQPHessianProxy)Proxy.getInvocationHandler(value);
            return this._factory.equals(handler._factory);
        }
        if (methodName.equals("hashCode") && params.length == 0) {
            return this._factory.hashCode();
        }
        if (methodName.equals("toString") && params.length == 0) {
            return "[HessianProxy " + proxy.getClass() + "]";
        }
        ConnectionFactory connectionFactory = this._factory.getConnectionFactory();
        try {
            int code;
            Message response = this.sendRequest(connectionFactory, method, args);
            if (response == null) {
                throw new TimeoutException();
            }
            MessageProperties props = response.getMessageProperties();
            boolean compressed = "deflate".equals(props.getContentEncoding());
            InputStream is = new ByteArrayInputStream(response.getBody());
            if (compressed) {
                is = new InflaterInputStream(is, new Inflater(true));
            }
            if ((code = is.read()) == 72) {
                int major = is.read();
                int minor = is.read();
                AbstractHessianInput in = this._factory.getHessian2Input(is);
                return in.readReply(method.getReturnType());
            }
            if (code == 114) {
                int major = is.read();
                int minor = is.read();
                AbstractHessianInput in = this._factory.getHessianInput(is);
                in.startReplyBody();
                Object value = in.readObject(method.getReturnType());
                in.completeReply();
                return value;
            }
            throw new HessianProtocolException("'" + (char)code + "' is an unknown code");
        }
        catch (HessianProtocolException e) {
            throw new HessianRuntimeException((Throwable)e);
        }
    }

    private Message sendRequest(ConnectionFactory connectionFactory, Method method, Object[] args) throws IOException {
        RabbitTemplate template = this._factory.getTemplate();
        byte[] payload = this.createRequestBody(method, args);
        MessageProperties messageProperties = new MessageProperties();
        messageProperties.setContentType("x-application/hessian");
        if (this._factory.isCompressed()) {
            messageProperties.setContentEncoding("deflate");
        }
        Message message = new Message(payload, messageProperties);
        Message response = template.sendAndReceive(this._factory.getRequestExchangeName(this._factory.getServiceInterface()), this._factory.getRequestQueueName(this._factory.getServiceInterface()), message);
        return response;
    }

    private byte[] createRequestBody(Method method, Object[] args) throws IOException {
        OutputStream os;
        String methodName = method.getName();
        if (this._factory.isOverloadEnabled() && args != null && args.length > 0) {
            methodName = AbstractSkeleton.mangleName((Method)method, (boolean)false);
        }
        ByteArrayOutputStream payload = new ByteArrayOutputStream(256);
        if (this._factory.isCompressed()) {
            Deflater deflater = new Deflater(-1, true);
            os = new DeflaterOutputStream((OutputStream)payload, deflater);
        } else {
            os = payload;
        }
        AbstractHessianOutput out = this._factory.getHessianOutput(os);
        out.call(methodName, args);
        if (os instanceof DeflaterOutputStream) {
            ((DeflaterOutputStream)os).finish();
        }
        out.flush();
        return payload.toByteArray();
    }
}

