/*
 * Decompiled with CFR 0.152.
 */
package org.resthub.rpc;

import com.caucho.hessian.io.SerializerFactory;
import org.resthub.rpc.RawMessageDelegate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.AmqpAdmin;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.rabbit.connection.Connection;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionListener;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.amqp.rabbit.listener.SimpleMessageListenerContainer;
import org.springframework.amqp.rabbit.listener.adapter.MessageListenerAdapter;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class HessianEndpoint
implements InitializingBean,
DisposableBean {
    private static final Logger logger = LoggerFactory.getLogger(HessianEndpoint.class);
    private Class<?> serviceAPI;
    private Object serviceImpl;
    private SerializerFactory serializerFactory;
    private ConnectionFactory connectionFactory;
    private SimpleMessageListenerContainer listenerContainer;
    private AmqpAdmin admin;
    private int concurentConsumers;
    private String queuePrefix;

    public HessianEndpoint() {
        this.setServiceAPI(this.findRemoteAPI(this.getClass()));
        this.setServiceImpl(this);
    }

    public HessianEndpoint(Object serviceImpl) {
        this.setServiceAPI(this.findRemoteAPI(serviceImpl.getClass()));
        this.setServiceImpl(serviceImpl);
    }

    public void setServiceAPI(Class<?> serviceAPI) {
        this.serviceAPI = serviceAPI;
    }

    public void setServiceImpl(Object serviceImpl) {
        this.serviceImpl = serviceImpl;
    }

    public void setSerializerFactory(SerializerFactory factory) {
        this.serializerFactory = factory;
    }

    public SerializerFactory getSerializerFactory() {
        if (this.serializerFactory == null) {
            this.serializerFactory = new SerializerFactory();
        }
        return this.serializerFactory;
    }

    public String getQueuePrefix() {
        return this.queuePrefix;
    }

    public void setQueuePrefix(String prefix) {
        this.queuePrefix = prefix;
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public int getConcurentConsumers() {
        return this.concurentConsumers;
    }

    public void setConcurentConsumers(int concurentConsumers) {
        this.concurentConsumers = concurentConsumers;
    }

    public void setSendCollectionType(boolean sendType) {
        this.getSerializerFactory().setSendCollectionType(sendType);
    }

    private Class<?> findRemoteAPI(Class<?> implClass) {
        if (implClass == null) {
            return null;
        }
        Class<?>[] interfaces = implClass.getInterfaces();
        if (interfaces.length == 1) {
            return interfaces[0];
        }
        return this.findRemoteAPI(implClass.getSuperclass());
    }

    private String getRequestQueueName(Class<?> cls) {
        String requestQueue = cls.getSimpleName();
        if (this.queuePrefix != null) {
            requestQueue = this.queuePrefix + "." + requestQueue;
        }
        return requestQueue;
    }

    private void createQueue(AmqpAdmin admin, String name) {
        Queue requestQueue = new Queue(name, false, false, false);
        admin.declareQueue(requestQueue);
    }

    public void run() {
        logger.debug("Launching endpoint for service : " + this.serviceAPI.getSimpleName());
        this.admin = new RabbitAdmin(this.connectionFactory);
        this.connectionFactory.addConnectionListener(new ConnectionListener(){

            public void onCreate(Connection connection) {
                HessianEndpoint.this.createQueue(HessianEndpoint.this.admin, HessianEndpoint.this.getRequestQueueName(HessianEndpoint.this.serviceAPI));
            }

            public void onClose(Connection connection) {
            }
        });
        this.createQueue(this.admin, this.getRequestQueueName(this.serviceAPI));
        MessageListenerAdapter listenerAdapter = new MessageListenerAdapter((Object)new RawMessageDelegate(this.serviceAPI, this.serviceImpl, this.serializerFactory));
        listenerAdapter.setMessageConverter(null);
        listenerAdapter.setMandatoryPublish(false);
        this.listenerContainer = new SimpleMessageListenerContainer();
        this.listenerContainer.setConnectionFactory(this.connectionFactory);
        this.listenerContainer.setQueueNames(new String[]{this.getRequestQueueName(this.serviceAPI)});
        this.listenerContainer.setMessageListener((Object)listenerAdapter);
        if (this.concurentConsumers > 0) {
            this.listenerContainer.setConcurrentConsumers(this.concurentConsumers);
        }
        this.listenerContainer.start();
    }

    public void afterPropertiesSet() throws Exception {
        if (this.connectionFactory == null) {
            throw new IllegalArgumentException("Property 'connectionFactory' is required");
        }
        this.run();
    }

    public void destroy() {
        this.listenerContainer.destroy();
    }
}

