/*
 * Decompiled with CFR 0.152.
 */
package org.resthub.rpc;

import com.caucho.hessian.io.AbstractHessianInput;
import com.caucho.hessian.io.AbstractHessianOutput;
import com.caucho.hessian.io.Hessian2Input;
import com.caucho.hessian.io.Hessian2Output;
import com.caucho.hessian.io.HessianDebugInputStream;
import com.caucho.hessian.io.HessianInput;
import com.caucho.hessian.io.HessianOutput;
import com.caucho.hessian.io.HessianRemoteResolver;
import com.caucho.hessian.io.SerializerFactory;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import org.resthub.rpc.AMQPHessianProxy;
import org.springframework.amqp.core.AmqpAdmin;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.DirectExchange;
import org.springframework.amqp.core.Exchange;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.rabbit.connection.Connection;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionListener;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.rabbit.listener.SimpleMessageListenerContainer;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class AMQPHessianProxyFactory
implements InitializingBean,
DisposableBean {
    private SerializerFactory _serializerFactory;
    private HessianRemoteResolver _resolver;
    private ConnectionFactory connectionFactory;
    private RabbitTemplate template;
    private AmqpAdmin admin;
    private SimpleMessageListenerContainer listener;
    private String replyQueueName;
    private AtomicBoolean initializing = new AtomicBoolean(false);
    protected Class<?> serviceInterface;
    private String queuePrefix;
    private boolean isOverloadEnabled = false;
    private boolean isHessian2Reply = true;
    private boolean isHessian2Request = true;
    private boolean debug = false;
    private long readTimeout = -1L;
    private boolean compressed;

    public String getQueuePrefix() {
        return this.queuePrefix;
    }

    public void setQueuePrefix(String queuePrefix) {
        this.queuePrefix = queuePrefix;
    }

    public void setDebug(boolean isDebug) {
        this.debug = isDebug;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public boolean isOverloadEnabled() {
        return this.isOverloadEnabled;
    }

    public void setOverloadEnabled(boolean isOverloadEnabled) {
        this.isOverloadEnabled = isOverloadEnabled;
    }

    public long getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(long timeout) {
        this.readTimeout = timeout;
    }

    public boolean isCompressed() {
        return this.compressed;
    }

    public void setCompressed(boolean compressed) {
        this.compressed = compressed;
    }

    public void setHessian2Reply(boolean isHessian2) {
        this.isHessian2Reply = isHessian2;
    }

    public void setHessian2Request(boolean isHessian2) {
        this.isHessian2Request = isHessian2;
        if (isHessian2) {
            this.isHessian2Reply = true;
        }
    }

    public HessianRemoteResolver getRemoteResolver() {
        return this._resolver;
    }

    public void setSerializerFactory(SerializerFactory factory) {
        this._serializerFactory = factory;
    }

    public SerializerFactory getSerializerFactory() {
        if (this._serializerFactory == null) {
            this._serializerFactory = new SerializerFactory();
        }
        return this._serializerFactory;
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public RabbitTemplate getTemplate() {
        return this.template;
    }

    public Class<?> getServiceInterface() {
        return this.serviceInterface;
    }

    public void setServiceInterface(Class<?> serviceInterface) {
        if (null == serviceInterface || !serviceInterface.isInterface()) {
            throw new IllegalArgumentException("'serviceInterface' is null or is not an interface");
        }
        this.serviceInterface = serviceInterface;
    }

    public <T> T create(Class<T> api) {
        if (null == api || !api.isInterface()) {
            throw new IllegalArgumentException("Parameter 'api' is required");
        }
        this.serviceInterface = api;
        this.afterPropertiesSet();
        AMQPHessianProxy handler = new AMQPHessianProxy(this);
        return (T)Proxy.newProxyInstance(api.getClassLoader(), new Class[]{api}, (InvocationHandler)handler);
    }

    AbstractHessianInput getHessianInput(InputStream is) {
        return this.getHessian2Input(is);
    }

    AbstractHessianInput getHessian1Input(InputStream is) {
        if (this.debug) {
            is = new HessianDebugInputStream(is, new PrintWriter(System.out));
        }
        HessianInput in = new HessianInput(is);
        in.setRemoteResolver(this.getRemoteResolver());
        in.setSerializerFactory(this.getSerializerFactory());
        return in;
    }

    AbstractHessianInput getHessian2Input(InputStream is) {
        if (this.debug) {
            is = new HessianDebugInputStream(is, new PrintWriter(System.out));
        }
        Hessian2Input in = new Hessian2Input(is);
        in.setRemoteResolver(this.getRemoteResolver());
        in.setSerializerFactory(this.getSerializerFactory());
        return in;
    }

    AbstractHessianOutput getHessianOutput(OutputStream os) {
        Hessian2Output out;
        if (this.isHessian2Request) {
            out = new Hessian2Output(os);
        } else {
            HessianOutput out1 = new HessianOutput(os);
            out = out1;
            if (this.isHessian2Reply) {
                out1.setVersion(2);
            }
        }
        out.setSerializerFactory(this.getSerializerFactory());
        return out;
    }

    private void createRequestQueue(AmqpAdmin admin, String queueName, String exchangeName) {
        Queue requestQueue = new Queue(queueName, false, false, false);
        admin.declareQueue(requestQueue);
        DirectExchange requestExchange = new DirectExchange(exchangeName, false, false);
        admin.declareExchange((Exchange)requestExchange);
        Binding requestBinding = BindingBuilder.bind((Queue)requestQueue).to(requestExchange).with(queueName);
        admin.declareBinding(requestBinding);
    }

    private Queue createReplyQueue(AmqpAdmin admin, String queueName) {
        Queue replyQueue = new Queue(queueName, false, true, false);
        admin.declareQueue(replyQueue);
        return replyQueue;
    }

    public String getRequestExchangeName(Class<?> cls) {
        String requestExchange = cls.getSimpleName();
        if (this.queuePrefix != null) {
            requestExchange = this.queuePrefix + "." + requestExchange;
        }
        return requestExchange;
    }

    public String getRequestQueueName(Class<?> cls) {
        String requestQueue = cls.getSimpleName();
        if (this.queuePrefix != null) {
            requestQueue = this.queuePrefix + "." + requestQueue;
        }
        return requestQueue;
    }

    private String getReplyQueueName(Class<?> cls) {
        String uuid = UUID.randomUUID().toString();
        String replyQueue = cls.getSimpleName() + "-reply-" + uuid;
        if (this.queuePrefix != null) {
            replyQueue = this.queuePrefix + "." + replyQueue;
        }
        return replyQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeQueues() {
        if (!this.initializing.compareAndSet(false, true)) {
            return;
        }
        try {
            if (this.admin == null) {
                this.admin = new RabbitAdmin(this.connectionFactory);
            }
            this.createRequestQueue(this.admin, this.getRequestQueueName(this.serviceInterface), this.getRequestExchangeName(this.serviceInterface));
            if (this.replyQueueName == null) {
                this.replyQueueName = this.getReplyQueueName(this.serviceInterface);
            }
            Queue replyQueue = this.createReplyQueue(this.admin, this.replyQueueName);
            this.template.setReplyQueue(replyQueue);
            if (this.listener == null || !this.listener.isRunning()) {
                this.listener = new SimpleMessageListenerContainer(this.connectionFactory);
                this.listener.setMessageListener((Object)this.template);
                this.listener.setQueues(new Queue[]{replyQueue});
                this.listener.start();
            }
        }
        finally {
            this.initializing.compareAndSet(true, false);
        }
    }

    public void afterPropertiesSet() {
        if (this.connectionFactory == null) {
            throw new IllegalArgumentException("Property 'connectionFactory' is required");
        }
        this.template = new RabbitTemplate(this.connectionFactory);
        if (this.readTimeout > 0L) {
            this.template.setReplyTimeout(this.readTimeout);
        }
        this.initializeQueues();
        this.connectionFactory.addConnectionListener(new ConnectionListener(){

            public void onCreate(Connection connection) {
                AMQPHessianProxyFactory.this.initializeQueues();
            }

            public void onClose(Connection connection) {
            }
        });
    }

    public void destroy() throws Exception {
        this.listener.destroy();
    }
}

