/*
 * Decompiled with CFR 0.152.
 */
package org.resthub.rpc;

import com.caucho.hessian.io.AbstractHessianOutput;
import com.caucho.hessian.io.HessianFactory;
import com.caucho.hessian.io.HessianInputFactory;
import com.caucho.hessian.io.HessianOutput;
import com.caucho.hessian.io.SerializerFactory;
import com.caucho.hessian.server.HessianSkeleton;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageProperties;

public class RawMessageDelegate {
    private static final Logger logger = LoggerFactory.getLogger(RawMessageDelegate.class);
    private static String SPRING_CORRELATION_ID = "spring_reply_correlation";
    private Class<?> serviceAPI;
    private Object serviceImpl;
    private SerializerFactory serializerFactory;

    public RawMessageDelegate() {
    }

    public RawMessageDelegate(Class<?> serviceAPI, Object serviceImpl, SerializerFactory serializerFactory) {
        this.serviceAPI = serviceAPI;
        this.serviceImpl = serviceImpl;
        this.serializerFactory = serializerFactory;
    }

    public void setServiceAPI(Class<?> serviceAPI) {
        this.serviceAPI = serviceAPI;
    }

    public void setServiceImpl(Object serviceImpl) {
        this.serviceImpl = serviceImpl;
    }

    public void setSerializerFactory(SerializerFactory factory) {
        this.serializerFactory = factory;
    }

    public SerializerFactory getSerializerFactory() {
        if (this.serializerFactory == null) {
            this.serializerFactory = new SerializerFactory();
        }
        return this.serializerFactory;
    }

    public Message handleMessage(Message message) {
        byte[] response;
        logger.debug("Message received : " + message);
        MessageProperties props = message.getMessageProperties();
        boolean compressed = "deflate".equals(props.getContentEncoding());
        try {
            response = this.createResponseBody(message.getBody(), compressed);
        }
        catch (Throwable e) {
            logger.error("Exception occurs during method call", e);
            e.printStackTrace();
            compressed = false;
            response = this.createFaultBody(message.getBody(), e);
        }
        MessageProperties messageProperties = new MessageProperties();
        messageProperties.setContentType("x-application/hessian");
        messageProperties.setHeader(SPRING_CORRELATION_ID, message.getMessageProperties().getHeaders().get(SPRING_CORRELATION_ID));
        if (compressed) {
            messageProperties.setContentEncoding("deflate");
        }
        return new Message(response, messageProperties);
    }

    private byte[] createResponseBody(byte[] request, boolean compressed) throws Exception {
        OutputStream out;
        InputStream in = new ByteArrayInputStream(request);
        if (compressed) {
            in = new InflaterInputStream(new ByteArrayInputStream(request), new Inflater(true));
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        if (compressed) {
            Deflater deflater = new Deflater(-1, true);
            out = new DeflaterOutputStream((OutputStream)bout, deflater);
        } else {
            out = bout;
        }
        HessianSkeleton skeleton = new HessianSkeleton(this.serviceImpl, this.serviceAPI);
        skeleton.invoke(in, out, this.getSerializerFactory());
        if (out instanceof DeflaterOutputStream) {
            ((DeflaterOutputStream)out).finish();
        }
        out.flush();
        out.close();
        return bout.toByteArray();
    }

    private byte[] createFaultBody(byte[] request, Throwable cause) {
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(request);
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            AbstractHessianOutput out = this.createHessianOutput(new HessianInputFactory().readHeader((InputStream)is), os);
            out.writeFault(cause.getClass().getSimpleName(), cause.getMessage(), (Object)cause);
            out.close();
            return os.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private AbstractHessianOutput createHessianOutput(HessianInputFactory.HeaderType header, OutputStream os) {
        HessianOutput out;
        HessianFactory hessianfactory = new HessianFactory();
        switch (header) {
            case CALL_1_REPLY_1: {
                out = hessianfactory.createHessianOutput(os);
                break;
            }
            case CALL_1_REPLY_2: 
            case HESSIAN_2: {
                out = hessianfactory.createHessian2Output(os);
                break;
            }
            default: {
                throw new IllegalStateException(header + " is an unknown Hessian call");
            }
        }
        return out;
    }
}

