/*
 * Decompiled with CFR 0.152.
 */
package org.resthub.rpc.serializer;

import com.caucho.hessian.io.AbstractHessianOutput;
import com.caucho.hessian.io.CollectionSerializer;
import com.caucho.hessian.io.HessianProtocolException;
import com.caucho.hessian.io.MapSerializer;
import com.caucho.hessian.io.Serializer;
import com.caucho.hessian.io.SerializerFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.Hibernate;
import org.hibernate.collection.internal.AbstractPersistentCollection;
import org.hibernate.collection.internal.PersistentMap;

public class HibernateSerializerFactory
extends SerializerFactory {
    private HibernateListSerializer listSerializer = new HibernateListSerializer();
    private HibernateMapSerializer mapSerializer = new HibernateMapSerializer();

    public Serializer getSerializer(Class cl) throws HessianProtocolException {
        if (PersistentMap.class.isAssignableFrom(cl)) {
            return this.mapSerializer;
        }
        if (AbstractPersistentCollection.class.isAssignableFrom(cl)) {
            return this.listSerializer;
        }
        return super.getSerializer(cl);
    }

    private static class HibernateMapSerializer
    implements Serializer {
        private MapSerializer delegate = new MapSerializer();

        private HibernateMapSerializer() {
        }

        public void writeObject(Object obj, AbstractHessianOutput out) throws IOException {
            if (Hibernate.isInitialized((Object)obj)) {
                this.delegate.writeObject(new HashMap((Map)obj), out);
            } else {
                this.delegate.writeObject(new HashMap(), out);
            }
        }
    }

    private static class HibernateListSerializer
    implements Serializer {
        private CollectionSerializer delegate = new CollectionSerializer();

        private HibernateListSerializer() {
        }

        public void writeObject(Object obj, AbstractHessianOutput out) throws IOException {
            if (Hibernate.isInitialized((Object)obj)) {
                this.delegate.writeObject(new ArrayList((Collection)obj), out);
            } else {
                this.delegate.writeObject(new ArrayList(), out);
            }
        }
    }
}

