/*
 * Decompiled with CFR 0.152.
 */
package org.resthub.web.springmvc.router;

import java.lang.reflect.Method;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPRequestAdapter {
    private static final Logger logger = LoggerFactory.getLogger(HTTPRequestAdapter.class);
    public String host;
    public String path;
    public String contextPath;
    public String servletPath;
    public String querystring;
    public String url;
    public String method;
    public String domain;
    public String remoteAddress;
    public String contentType;
    public String controller;
    public String actionMethod;
    public Integer port;
    public Map<String, Header> headers = new HashMap<String, Header>();
    public Map<String, String> routeArgs;
    public String format = null;
    public String action;
    public transient Method invokedMethod;
    public transient Class controllerClass;
    public Map<String, Object> args = new HashMap<String, Object>();
    public Date date = new Date();
    public Boolean secure = false;
    public static ThreadLocal<HTTPRequestAdapter> current = new ThreadLocal();

    public HTTPRequestAdapter(HttpServletRequest _request) {
        this.headers = new HashMap<String, Header>();
    }

    public void setFormat(String _format) {
        this.format = _format;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getQueryString() {
        return this.querystring;
    }

    public void setQueryString(String queryString) {
        this.querystring = queryString;
    }

    public String getBase() {
        if (this.port == 80 || this.port == 443) {
            return String.format("%s://%s", this.secure != false ? "https" : "http", this.domain).intern();
        }
        return String.format("%s://%s:%s", this.secure != false ? "https" : "http", this.domain, this.port).intern();
    }

    public static HTTPRequestAdapter parseRequest(HttpServletRequest httpServletRequest) throws Exception {
        HTTPRequestAdapter request = new HTTPRequestAdapter(httpServletRequest);
        current.set(request);
        URI uri = new URI(httpServletRequest.getRequestURI());
        request.method = httpServletRequest.getMethod().intern();
        request.path = httpServletRequest.getPathInfo() != null ? httpServletRequest.getPathInfo() : httpServletRequest.getServletPath();
        request.servletPath = httpServletRequest.getServletPath() != null ? httpServletRequest.getServletPath() : "";
        request.contextPath = httpServletRequest.getContextPath() != null ? httpServletRequest.getContextPath() : "";
        request.setQueryString(httpServletRequest.getQueryString() == null ? "" : httpServletRequest.getQueryString());
        logger.trace("contextPath: " + request.contextPath, (Object)(" servletPath: " + request.servletPath));
        logger.trace("request.path: " + request.path + ", request.querystring: " + request.getQueryString());
        request.contentType = httpServletRequest.getHeader("Content-Type") != null ? httpServletRequest.getHeader("Content-Type").split(";")[0].trim().toLowerCase().intern() : "text/html".intern();
        if (httpServletRequest.getHeader("X-HTTP-Method-Override") != null) {
            request.method = httpServletRequest.getHeader("X-HTTP-Method-Override").intern();
        }
        request.setSecure(httpServletRequest.isSecure());
        request.url = httpServletRequest.getRequestURI();
        request.host = httpServletRequest.getHeader("host");
        if (request.host.contains(":")) {
            request.port = Integer.parseInt(request.host.split(":")[1]);
            request.domain = request.host.split(":")[0];
        } else {
            request.port = 80;
            request.domain = request.host;
        }
        request.remoteAddress = httpServletRequest.getRemoteAddr();
        Enumeration headersNames = httpServletRequest.getHeaderNames();
        while (headersNames.hasMoreElements()) {
            Header hd = request.new Header();
            hd.name = (String)headersNames.nextElement();
            hd.values = new ArrayList<String>();
            Enumeration enumValues = httpServletRequest.getHeaders(hd.name);
            while (enumValues.hasMoreElements()) {
                String value = (String)enumValues.nextElement();
                hd.values.add(value);
            }
            request.headers.put(hd.name.toLowerCase(), hd);
        }
        request.resolveFormat();
        return request;
    }

    public void resolveFormat() {
        if (this.format != null) {
            return;
        }
        if (this.headers.get("accept") == null) {
            this.format = "html".intern();
            return;
        }
        String accept = this.headers.get("accept").value();
        if (accept.contains("application/xhtml") || accept.contains("text/html") || accept.startsWith("*/*")) {
            this.format = "html".intern();
            return;
        }
        if (accept.contains("application/xml") || accept.contains("text/xml")) {
            this.format = "xml".intern();
            return;
        }
        if (accept.contains("text/plain")) {
            this.format = "txt".intern();
            return;
        }
        if (accept.contains("application/json") || accept.contains("text/javascript")) {
            this.format = "json".intern();
            return;
        }
        if (accept.endsWith("*/*")) {
            this.format = "html".intern();
        }
    }

    public class Header {
        public String name;
        public List<String> values;

        public String value() {
            return this.values.get(0);
        }
    }
}

