/*
 * Decompiled with CFR 0.152.
 */
package org.resthub.web.springmvc.router;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jregex.Matcher;
import jregex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.resthub.web.springmvc.router.HTTPRequestAdapter;
import org.resthub.web.springmvc.router.exceptions.NoHandlerFoundException;
import org.resthub.web.springmvc.router.exceptions.NoRouteFoundException;
import org.resthub.web.springmvc.router.exceptions.RouteFileParsingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public class Router {
    static Pattern routePattern = new Pattern("^({method}GET|POST|PUT|DELETE|PATCH|OPTIONS|HEAD|\\*)[(]?({headers}[^)]*)(\\))?\\s+({path}.*/[^\\s]*)\\s+({action}[^\\s(]+)({params}.+)?(\\s*)$");
    static Pattern methodOverride = new Pattern("^.*x-http-method-override=({method}GET|PUT|POST|DELETE|PATCH).*$");
    public static long lastLoading = -1L;
    private static final Logger logger = LoggerFactory.getLogger(Router.class);
    public static List<Route> routes = new ArrayList<Route>(500);

    public static void clear() {
        routes.clear();
    }

    public static void load(List<Resource> fileResources) throws IOException {
        routes.clear();
        for (Resource res : fileResources) {
            Router.parse(res);
        }
        lastLoading = System.currentTimeMillis();
    }

    public static void prependRoute(String method, String path, String action, String headers) {
        Router.prependRoute(method, path, action, null, headers);
    }

    public static void prependRoute(String method, String path, String action) {
        Router.prependRoute(method, path, action, null, null);
    }

    public static void addRoute(int position, String method, String path, String action, String params, String headers) {
        if (position > routes.size()) {
            position = routes.size();
        }
        routes.add(position, Router.getRoute(method, path, action, params, headers));
    }

    public static void addRoute(int position, String method, String path, String headers) {
        Router.addRoute(position, method, path, null, null, headers);
    }

    public static void addRoute(int position, String method, String path, String action, String headers) {
        Router.addRoute(position, method, path, action, null, headers);
    }

    public static void addRoute(String method, String path, String action) {
        Router.prependRoute(method, path, action);
    }

    public static void addRoute(String method, String path, String action, String headers) {
        Router.addRoute(method, path, action, null, headers);
    }

    public static void addRoute(String method, String path, String action, String params, String headers) {
        Router.appendRoute(method, path, action, params, headers, null, 0);
    }

    public static void appendRoute(String method, String path, String action, String params, String headers, String sourceFile, int line) {
        routes.add(Router.getRoute(method, path, action, params, headers, sourceFile, line));
    }

    public static Route getRoute(String method, String path, String action, String params, String headers) {
        return Router.getRoute(method, path, action, params, headers, null, 0);
    }

    public static Route getRoute(String method, String path, String action, String params, String headers, String sourceFile, int line) {
        Route route = new Route();
        route.method = method;
        route.path = path.replace("//", "/");
        route.action = action;
        route.routesFile = sourceFile;
        route.routesFileLine = line;
        route.addFormat(headers);
        route.addParams(params);
        route.compute();
        if (logger.isDebugEnabled()) {
            logger.debug("Adding [" + route.toString() + "] with params [" + params + "] and headers [" + headers + "]");
        }
        return route;
    }

    public static void prependRoute(String method, String path, String action, String params, String headers) {
        routes.add(0, Router.getRoute(method, path, action, params, headers));
    }

    static void parse(Resource fileResource) throws IOException {
        String fileAbsolutePath = fileResource.getFile().getAbsolutePath();
        String content = IOUtils.toString((InputStream)fileResource.getInputStream());
        Router.parse(content, fileAbsolutePath);
    }

    static void parse(String content, String fileAbsolutePath) throws IOException {
        int lineNumber = 0;
        for (String line : content.split("\n")) {
            ++lineNumber;
            if ((line = line.trim().replaceAll("\\s+", " ")).length() == 0 || line.startsWith("#")) continue;
            Matcher matcher = routePattern.matcher(line);
            if (matcher.matches()) {
                String action = matcher.group("action");
                String method = matcher.group("method");
                String path = matcher.group("path");
                String params = matcher.group("params");
                String headers = matcher.group("headers");
                Router.appendRoute(method, path, action, params, headers, fileAbsolutePath, lineNumber);
                continue;
            }
            logger.error("Invalid route definition : " + line);
        }
    }

    public static void detectChanges(List<Resource> fileResources) throws IOException {
        boolean hasChanged = false;
        for (Resource res : fileResources) {
            if (!FileUtils.isFileNewer((File)res.getFile(), (long)lastLoading)) continue;
            hasChanged = true;
            break;
        }
        if (hasChanged) {
            Router.load(fileResources);
        }
    }

    public static Route route(HTTPRequestAdapter request) {
        Matcher matcher;
        if (logger.isTraceEnabled()) {
            logger.trace("Route: " + request.path + " - " + request.querystring);
        }
        if (request.querystring != null && methodOverride.matches(request.querystring) && (matcher = methodOverride.matcher(request.querystring)).matches()) {
            if (logger.isTraceEnabled()) {
                logger.trace("request method %s overriden to %s ", (Object)request.method, (Object)matcher.group("method"));
            }
            request.method = matcher.group("method");
        }
        for (Route route : routes) {
            String host;
            String format;
            Map<String, String> args = route.matches(request.method, request.path, format = request.format, host = request.host);
            if (args == null) continue;
            request.routeArgs = args;
            request.action = route.action;
            if (args.containsKey("format")) {
                request.setFormat(args.get("format"));
            }
            if (request.action.indexOf("{") > -1) {
                for (String arg : request.routeArgs.keySet()) {
                    request.action = request.action.replace("{" + arg + "}", request.routeArgs.get(arg));
                }
            }
            return route;
        }
        if (request.method.equalsIgnoreCase("head")) {
            request.method = "GET";
            Route route = Router.route(request);
            request.method = "HEAD";
            if (route != null) {
                return route;
            }
        }
        throw new NoRouteFoundException(request.method, request.path);
    }

    public static Map<String, String> route(String method, String path) {
        return Router.route(method, path, null, null);
    }

    public static Map<String, String> route(String method, String path, String headers) {
        return Router.route(method, path, headers, null);
    }

    public static Map<String, String> route(String method, String path, String headers, String host) {
        for (Route route : routes) {
            Map<String, String> args = route.matches(method, path, headers, host);
            if (args == null) continue;
            args.put("action", route.action);
            return args;
        }
        return new HashMap<String, String>(16);
    }

    public static ActionDefinition reverse(String action) {
        return Router.reverse(action, new HashMap<String, Object>(16));
    }

    public static String getFullUrl(String action, Map<String, Object> args) {
        return HTTPRequestAdapter.getCurrent().getBase() + Router.reverse(action, args);
    }

    public static String getFullUrl(String action) {
        return Router.getFullUrl(action, new HashMap<String, Object>(16));
    }

    public static Collection<Route> resolveActions(String action) {
        ArrayList<Route> candidateRoutes = new ArrayList<Route>(3);
        for (Route route : routes) {
            Matcher matcher;
            if (route.actionPattern == null || !(matcher = route.actionPattern.matcher(action)).matches()) continue;
            candidateRoutes.add(route);
        }
        return candidateRoutes;
    }

    public static ActionDefinition reverse(String action, Map<String, Object> args) {
        HTTPRequestAdapter currentRequest = HTTPRequestAdapter.getCurrent();
        HashMap<String, Object> argsbackup = new HashMap<String, Object>(args);
        for (Route route : routes) {
            Matcher matcher;
            if (route.actionPattern == null || !(matcher = route.actionPattern.matcher(action)).matches()) continue;
            for (String group : route.actionArgs) {
                String v = matcher.group(group);
                if (v == null) continue;
                args.put(group, v.toLowerCase());
            }
            ArrayList<String> inPathArgs = new ArrayList<String>(16);
            boolean allRequiredArgsAreHere = true;
            for (Route.Arg arg : route.args) {
                inPathArgs.add(arg.name);
                Object value = args.get(arg.name);
                if (value == null) {
                    String host = route.host.replaceAll("\\{", "").replaceAll("\\}", "");
                    if (host.equals(arg.name) || host.matches(arg.name)) {
                        args.put(arg.name, "");
                        value = "";
                        continue;
                    }
                    allRequiredArgsAreHere = false;
                    break;
                }
                if (value instanceof List) {
                    List l = (List)value;
                    value = l.get(0);
                }
                if (value.toString().startsWith(":") || arg.constraint.matches(value.toString())) continue;
                allRequiredArgsAreHere = false;
                break;
            }
            for (String staticKey : route.staticArgs.keySet()) {
                if (staticKey.equals("format")) {
                    if (currentRequest.format.equals(route.staticArgs.get("format"))) continue;
                    allRequiredArgsAreHere = false;
                    break;
                }
                if (args.containsKey(staticKey) && args.get(staticKey) != null && args.get(staticKey).toString().equals(route.staticArgs.get(staticKey))) continue;
                allRequiredArgsAreHere = false;
                break;
            }
            if (!allRequiredArgsAreHere) continue;
            StringBuilder queryString = new StringBuilder();
            String path = route.path;
            if (currentRequest != null) {
                if (!currentRequest.servletPath.isEmpty() && !currentRequest.servletPath.equals("/")) {
                    String servletPath = currentRequest.servletPath;
                    path = (servletPath.startsWith("/") ? servletPath : "/" + servletPath) + path;
                }
                if (!currentRequest.contextPath.isEmpty() && !currentRequest.contextPath.equals("/")) {
                    String contextPath = currentRequest.contextPath;
                    path = (contextPath.startsWith("/") ? contextPath : "/" + contextPath) + path;
                }
            }
            String host = route.host;
            if (path.endsWith("/?")) {
                path = path.substring(0, path.length() - 2);
            }
            for (Map.Entry<String, Object> entry : args.entrySet()) {
                List vals;
                String key = entry.getKey();
                Object value = entry.getValue();
                if (inPathArgs.contains(key) && value != null) {
                    if (List.class.isAssignableFrom(value.getClass())) {
                        vals = (List)value;
                        try {
                            path = path.replaceAll("\\{(<[^>]+>)?" + key + "\\}", URLEncoder.encode(vals.get(0).toString().replace("$", "\\$"), "utf-8"));
                            continue;
                        }
                        catch (UnsupportedEncodingException e) {
                            throw new RouteFileParsingException("RouteFile encoding exception", e);
                        }
                    }
                    try {
                        path = path.replaceAll("\\{(<[^>]+>)?" + key + "\\}", URLEncoder.encode(value.toString().replace("$", "\\$"), "utf-8"));
                        host = host.replaceAll("\\{(<[^>]+>)?" + key + "\\}", URLEncoder.encode(value.toString().replace("$", "\\$"), "utf-8"));
                        continue;
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new RouteFileParsingException("RouteFile encoding exception", e);
                    }
                }
                if (route.staticArgs.containsKey(key) || value == null) continue;
                if (List.class.isAssignableFrom(value.getClass())) {
                    vals = (List)value;
                    for (Object object : vals) {
                        try {
                            queryString.append(URLEncoder.encode(key, "utf-8"));
                            queryString.append("=");
                            if (object.toString().startsWith(":")) {
                                queryString.append(object.toString());
                            } else {
                                queryString.append(URLEncoder.encode(object.toString() + "", "utf-8"));
                            }
                            queryString.append("&");
                        }
                        catch (UnsupportedEncodingException ex) {}
                    }
                    continue;
                }
                try {
                    queryString.append(URLEncoder.encode(key, "utf-8"));
                    queryString.append("=");
                    if (value.toString().startsWith(":")) {
                        queryString.append(value.toString());
                    } else {
                        queryString.append(URLEncoder.encode(value.toString() + "", "utf-8"));
                    }
                    queryString.append("&");
                }
                catch (UnsupportedEncodingException ex) {
                }
            }
            String qs = queryString.toString();
            if (qs.endsWith("&")) {
                qs = qs.substring(0, qs.length() - 1);
            }
            ActionDefinition actionDefinition = new ActionDefinition();
            actionDefinition.url = qs.length() == 0 ? path : path + "?" + qs;
            actionDefinition.method = route.method == null || route.method.equals("*") ? "GET" : route.method.toUpperCase();
            actionDefinition.star = "*".equals(route.method);
            actionDefinition.action = action;
            actionDefinition.args = argsbackup;
            actionDefinition.host = host;
            return actionDefinition;
        }
        throw new NoHandlerFoundException(action, args);
    }

    private static void addToQuerystring(StringBuilder queryString, String key, Object value) {
        if (List.class.isAssignableFrom(value.getClass())) {
            List vals = (List)value;
            for (Object object : vals) {
                try {
                    queryString.append(URLEncoder.encode(key, "utf-8"));
                    queryString.append("=");
                    if (object.toString().startsWith(":")) {
                        queryString.append(object.toString());
                    } else {
                        queryString.append(URLEncoder.encode(object.toString() + "", "utf-8"));
                    }
                    queryString.append("&");
                }
                catch (UnsupportedEncodingException ex) {}
            }
        } else {
            try {
                queryString.append(URLEncoder.encode(key, "utf-8"));
                queryString.append("=");
                if (value.toString().startsWith(":")) {
                    queryString.append(value.toString());
                } else {
                    queryString.append(URLEncoder.encode(value.toString() + "", "utf-8"));
                }
                queryString.append("&");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
    }

    public static class Route {
        public String method;
        public String path;
        public String action;
        Pattern actionPattern;
        List<String> actionArgs = new ArrayList<String>(3);
        Pattern pattern;
        Pattern hostPattern;
        List<Arg> args = new ArrayList<Arg>(3);
        Map<String, String> staticArgs = new HashMap<String, String>(3);
        List<String> formats = new ArrayList<String>(1);
        String host;
        Arg hostArg = null;
        public int routesFileLine;
        public String routesFile;
        static Pattern customRegexPattern = new Pattern("\\{([a-zA-Z_0-9]+)\\}");
        static Pattern argsPattern = new Pattern("\\{<([^>]+)>([a-zA-Z_0-9]+)\\}");
        static Pattern paramPattern = new Pattern("([a-zA-Z_0-9]+):'(.*)'");

        public String getAction() {
            return this.action;
        }

        public String getHost() {
            return this.host;
        }

        public String getMethod() {
            return this.method;
        }

        public String getPath() {
            return this.path;
        }

        public List<Arg> getArgs() {
            return this.args;
        }

        public void compute() {
            this.host = "";
            this.hostPattern = new Pattern(".*");
            if (!this.path.startsWith("/")) {
                String p = this.path;
                this.path = p.substring(p.indexOf("/"));
                this.host = p.substring(0, p.indexOf("/"));
                String pattern = this.host.replaceAll("\\.", "\\\\.").replaceAll("\\{.*\\}", "(.*)");
                if (logger.isTraceEnabled()) {
                    logger.trace("pattern [" + pattern + "]");
                    logger.trace("host [" + this.host + "]");
                }
                Matcher m = new Pattern(pattern).matcher(this.host);
                this.hostPattern = new Pattern(pattern);
                if (m.matches() && this.host.contains("{")) {
                    String name = m.group(1).replace("{", "").replace("}", "");
                    this.hostArg = new Arg();
                    this.hostArg.name = name;
                    if (logger.isTraceEnabled()) {
                        logger.trace("hostArg name [" + name + "]");
                    }
                    this.hostArg.defaultValue = this.host;
                    this.hostArg.constraint = new Pattern(".*");
                    if (logger.isTraceEnabled()) {
                        logger.trace("adding hostArg [" + this.hostArg + "]");
                    }
                    this.args.add(this.hostArg);
                }
            }
            String patternString = this.path;
            patternString = customRegexPattern.replacer("\\{<[^/]+>$1\\}").replace(patternString);
            Matcher matcher = argsPattern.matcher(patternString);
            while (matcher.find()) {
                Arg arg = new Arg();
                arg.name = matcher.group(2);
                arg.constraint = new Pattern(matcher.group(1));
                this.args.add(arg);
            }
            patternString = argsPattern.replacer("({$2}$1)").replace(patternString);
            this.pattern = new Pattern(patternString);
            patternString = this.action;
            patternString = patternString.replace(".", "[.]");
            for (Arg arg : this.args) {
                if (!patternString.contains("{" + arg.name + "}")) continue;
                patternString = patternString.replace("{" + arg.name + "}", "({" + arg.name + "}" + arg.constraint.toString() + ")");
                this.actionArgs.add(arg.name);
            }
            this.actionPattern = new Pattern(patternString, 1);
        }

        public void addParams(String params) {
            if (params == null || params.length() < 1) {
                return;
            }
            params = params.substring(1, params.length() - 1);
            for (String param : params.split(",")) {
                Matcher matcher = paramPattern.matcher(param);
                if (matcher.matches()) {
                    this.staticArgs.put(matcher.group(1), matcher.group(2));
                    continue;
                }
                logger.warn("Ignoring " + param + " (static params must be specified as key:'value',...)");
            }
        }

        public void addFormat(String params) {
            if (params == null || params.length() < 1) {
                return;
            }
            params = params.trim();
            this.formats.addAll(Arrays.asList(params.split(",")));
        }

        private boolean contains(String accept) {
            boolean contains;
            block2: {
                String format;
                boolean bl = contains = accept == null;
                if (accept == null) break block2;
                if (this.formats.isEmpty()) {
                    return true;
                }
                Iterator<String> i$ = this.formats.iterator();
                while (i$.hasNext() && !(contains = (format = i$.next()).startsWith(accept))) {
                }
            }
            return contains;
        }

        public Map<String, String> matches(String method, String path) {
            return this.matches(method, path, null, null);
        }

        public Map<String, String> matches(String method, String path, String accept) {
            return this.matches(method, path, accept, null);
        }

        public Map<String, String> matches(String method, String path, String accept, String domain) {
            if (method == null || this.method.equals("*") || method.equalsIgnoreCase(this.method) || method.equalsIgnoreCase("head") && "get".equalsIgnoreCase(this.method)) {
                boolean hostMatches;
                Matcher matcher = this.pattern.matcher(path);
                boolean bl = hostMatches = domain == null;
                if (domain != null) {
                    Matcher hostMatcher = this.hostPattern.matcher(domain);
                    hostMatches = hostMatcher.matches();
                }
                if (matcher.matches() && this.contains(accept) && hostMatches) {
                    HashMap<String, String> localArgs = new HashMap<String, String>();
                    for (Arg arg : this.args) {
                        if (arg.defaultValue != null) continue;
                        localArgs.put(arg.name, matcher.group(arg.name));
                    }
                    if (this.hostArg != null && domain != null) {
                        String routeValue = this.hostArg.defaultValue.replaceAll("\\{.*}", "");
                        domain = domain.replace(routeValue, "");
                        localArgs.put(this.hostArg.name, domain);
                    }
                    localArgs.putAll(this.staticArgs);
                    return localArgs;
                }
            }
            return null;
        }

        public String toString() {
            return this.method + " " + this.path + " -> " + this.action;
        }

        public static class Arg {
            String name;
            Pattern constraint;
            String defaultValue;
            Boolean optional = false;

            public String getName() {
                return this.name;
            }

            public String getDefaultValue() {
                return this.defaultValue;
            }
        }
    }

    public static class ActionDefinition {
        public String host;
        public String method;
        public String url;
        public boolean star;
        public String action;
        public Map<String, Object> args;

        public ActionDefinition add(String key, Object value) {
            this.args.put(key, value);
            return Router.reverse(this.action, this.args);
        }

        public ActionDefinition remove(String key) {
            this.args.remove(key);
            return Router.reverse(this.action, this.args);
        }

        public ActionDefinition addRef(String fragment) {
            this.url = this.url + "#" + fragment;
            return this;
        }

        public String toString() {
            return this.url;
        }

        public void absolute() {
            HTTPRequestAdapter currentRequest = HTTPRequestAdapter.getCurrent();
            if (!this.url.startsWith("http")) {
                this.url = this.host == null || this.host.isEmpty() ? currentRequest.getBase() + this.url : (currentRequest.secure != false ? "https://" : "http://") + this.host + this.url;
            }
        }

        public ActionDefinition secure() {
            if (!this.url.contains("http://") && !this.url.contains("https://")) {
                this.absolute();
            }
            this.url = this.url.replace("http:", "https:");
            return this;
        }
    }
}

