/*
 * Decompiled with CFR 0.152.
 */
package org.resthub.web.springmvc.router.hateoas;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.resthub.web.springmvc.router.Router;
import org.springframework.hateoas.Identifiable;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.LinkBuilder;
import org.springframework.util.Assert;

public class RouterLinkBuilder
implements LinkBuilder {
    private String controllerName;
    private String actionName;
    private List<Object> unresolvedArgs = new ArrayList<Object>(3);
    private Map<String, Object> resolvedArgs = new HashMap<String, Object>(3);

    public RouterLinkBuilder(String controllerAction) {
        Assert.hasLength((String)controllerAction, (String)"Controller.action should not be empty");
        String[] names = controllerAction.split("\\.");
        this.controllerName = names[0];
        if (names.length == 2) {
            this.actionName = names[1];
        }
    }

    public static RouterLinkBuilder linkTo(String controllerAction) {
        return new RouterLinkBuilder(controllerAction);
    }

    public static RouterLinkBuilder linkTo(String controllerName, String actionName) {
        return new RouterLinkBuilder(controllerName + "." + actionName);
    }

    public static RouterLinkBuilder linkTo(Class<?> controller) {
        return new RouterLinkBuilder(controller.getSimpleName());
    }

    public RouterLinkBuilder action(String actionName) {
        this.actionName = actionName;
        return this;
    }

    public RouterLinkBuilder slash(Object object) {
        if (object == null) {
            return this;
        }
        if (object instanceof Identifiable) {
            return this.slash((Identifiable)object);
        }
        this.unresolvedArgs.add(object);
        return this;
    }

    public RouterLinkBuilder slash(String name, Object object) {
        if (object == null) {
            return this;
        }
        if (object instanceof Identifiable) {
            return this.slash(name, (Identifiable)object);
        }
        this.resolvedArgs.put(name, object);
        return this;
    }

    public RouterLinkBuilder slash(Identifiable<?> identifiable) {
        return this.slash(identifiable.getId());
    }

    public RouterLinkBuilder slash(String name, Identifiable<?> identifiable) {
        return this.slash(name, identifiable.getId());
    }

    public URI toUri() {
        try {
            return new URI(this.toString());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Could not reverse controller.action to an URI", e);
        }
    }

    public String toString() {
        return Router.getFullUrl(this.controllerName + "." + this.actionName, this.resolveArgs());
    }

    public Link withRel(String rel) {
        return new Link(this.toString(), rel);
    }

    public Link withSelfRel() {
        return new Link(this.toString());
    }

    private Map<String, Object> resolveArgs() {
        if (this.unresolvedArgs.size() > 0) {
            Collection<Router.Route> routes = Router.resolveActions(this.controllerName + "." + this.actionName);
            int argsCount = this.unresolvedArgs.size() + this.resolvedArgs.size();
            for (Router.Route route : routes) {
                int routeArgsCount = route.getArgs().size();
                if (argsCount != routeArgsCount) continue;
                ArrayList<String> argNames = new ArrayList<String>();
                for (Router.Route.Arg arg : route.getArgs()) {
                    argNames.add(arg.getName());
                }
                if (!argNames.containsAll(this.resolvedArgs.keySet())) continue;
                for (String argName : argNames) {
                    if (this.resolvedArgs.containsKey(argName)) continue;
                    this.resolvedArgs.put(argName, this.unresolvedArgs.remove(0));
                }
            }
        }
        return this.resolvedArgs;
    }
}

