/*
 * Decompiled with CFR 0.152.
 */
package org.resthub.web.springmvc.view.velocity;

import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import jregex.Matcher;
import jregex.Pattern;
import org.apache.velocity.context.InternalContextAdapter;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.directive.Directive;
import org.apache.velocity.runtime.parser.node.Node;
import org.resthub.web.springmvc.router.Router;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RouteDirective
extends Directive {
    private static Pattern paramPattern = new Pattern("([a-zA-Z_0-9]+)\\s*:\\s*'(.*)'");
    private static Logger logger = LoggerFactory.getLogger(RouteDirective.class);

    public String getName() {
        return "route";
    }

    public int getType() {
        return 2;
    }

    public boolean render(InternalContextAdapter context, Writer writer, Node node) throws IOException, ResourceNotFoundException, ParseErrorException, MethodInvocationException {
        String route = null;
        String action = null;
        String params = null;
        HashMap<String, Object> args = new HashMap<String, Object>();
        if (node.jjtGetChild(0) != null) {
            route = String.valueOf(node.jjtGetChild(0).value(context));
            logger.debug("-- RouteDirective " + route);
            int index = route.indexOf(40);
            if (index > 0) {
                action = route.substring(0, index);
                params = route.substring(index + 1, route.length() - 1);
            } else {
                action = route;
            }
            if (params != null && params.length() > 1) {
                for (String param : params.split(",")) {
                    Matcher matcher = paramPattern.matcher(param);
                    if (matcher.matches()) {
                        args.put(matcher.group(1), matcher.group(2));
                        continue;
                    }
                    logger.warn("Ignoring " + params + " (static params must be specified as key:'value',...)");
                }
            }
        }
        writer.write(Router.reverse(action, args).url);
        return true;
    }
}

