/*
 * Decompiled with CFR 0.152.
 */
package org.resthub.web.springmvc.router;

import java.util.List;
import org.resthub.web.springmvc.router.RouterHandlerMapping;
import org.springframework.context.annotation.Bean;
import org.springframework.web.servlet.config.annotation.DelegatingWebMvcConfiguration;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

public abstract class RouterConfigurationSupport
extends DelegatingWebMvcConfiguration {
    @Bean
    public RouterHandlerMapping createRouterHandlerMapping() {
        RouterHandlerMapping handlerMapping = new RouterHandlerMapping();
        handlerMapping.setRouteFiles(this.listRouteFiles());
        handlerMapping.setAutoReloadEnabled(this.isHandlerMappingReloadEnabled());
        handlerMapping.setInterceptors(this.getInterceptors());
        handlerMapping.setOrder(0);
        return handlerMapping;
    }

    protected boolean isHandlerMappingReloadEnabled() {
        return false;
    }

    @Bean
    public RequestMappingHandlerMapping requestMappingHandlerMapping() {
        RequestMappingHandlerMapping handlerMapping = new RequestMappingHandlerMapping();
        handlerMapping.setOrder(3);
        handlerMapping.setInterceptors(this.getInterceptors());
        handlerMapping.setContentNegotiationManager(this.mvcContentNegotiationManager());
        return handlerMapping;
    }

    public abstract List<String> listRouteFiles();
}

