/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.routing;

import java.util.logging.Level;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Restlet;
import org.restlet.data.Reference;
import org.restlet.data.Status;
import org.restlet.routing.Route;
import org.restlet.routing.Router;
import org.restlet.routing.Template;

public class TemplateRoute
extends Route {
    private volatile boolean matchingQuery;
    private volatile Template template;

    public TemplateRoute(Restlet next) {
        this(null, (Template)null, next);
    }

    public TemplateRoute(Router router, String uriTemplate, Restlet next) {
        this(router, new Template(uriTemplate, 1, 14, "", true, false), next);
    }

    public TemplateRoute(Router router, Template template, Restlet next) {
        super(router, next);
        this.matchingQuery = router == null ? true : router.getDefaultMatchingQuery();
        this.template = template;
    }

    @Override
    protected int beforeHandle(Request request, Response response) {
        if (this.getTemplate() != null) {
            String remainingPart = request.getResourceRef().getRemainingPart(false, this.isMatchingQuery());
            int matchedLength = this.getTemplate().parse(remainingPart, request);
            if (matchedLength == 0) {
                if (request.isLoggable() && this.getLogger().isLoggable(Level.FINER)) {
                    this.getLogger().finer("No characters were matched");
                }
            } else if (matchedLength > 0) {
                if (request.isLoggable() && this.getLogger().isLoggable(Level.FINER)) {
                    this.getLogger().finer(matchedLength + " characters were matched");
                }
                String matchedPart = remainingPart.substring(0, matchedLength);
                Reference baseRef = request.getResourceRef().getBaseRef();
                baseRef = baseRef == null ? new Reference(matchedPart) : new Reference(baseRef.toString(false, false) + matchedPart);
                request.getResourceRef().setBaseRef(baseRef);
                if (request.isLoggable()) {
                    if (this.getLogger().isLoggable(Level.FINE)) {
                        remainingPart = request.getResourceRef().getRemainingPart(false, this.isMatchingQuery());
                        if (remainingPart != null && !"".equals(remainingPart)) {
                            this.getLogger().fine("New base URI: \"" + request.getResourceRef().getBaseRef() + "\". New remaining part: \"" + remainingPart + "\"");
                        } else {
                            this.getLogger().fine("New base URI: \"" + request.getResourceRef().getBaseRef() + "\". No remaining part to match");
                        }
                    }
                    if (this.getLogger().isLoggable(Level.FINER)) {
                        this.getLogger().finer("Delegating the call to the target Restlet");
                    }
                }
            } else {
                if (request.isLoggable() && this.getLogger().isLoggable(Level.FINE)) {
                    this.getLogger().fine("Unable to match this pattern: " + this.getTemplate().getPattern());
                }
                response.setStatus(Status.CLIENT_ERROR_NOT_FOUND);
            }
        }
        return 0;
    }

    public int getMatchingMode() {
        return this.getTemplate().getMatchingMode();
    }

    public Template getTemplate() {
        return this.template;
    }

    public boolean isMatchingQuery() {
        return this.matchingQuery;
    }

    @Override
    public float score(Request request, Response response) {
        float result = 0.0f;
        if (this.getRouter() != null && request.getResourceRef() != null && this.getTemplate() != null) {
            int matchedLength;
            String remainingPart = request.getResourceRef().getRemainingPart(false, this.isMatchingQuery());
            if (remainingPart != null && (matchedLength = this.getTemplate().match(remainingPart)) != -1) {
                float totalLength = remainingPart.length();
                result = totalLength > 0.0f ? this.getRouter().getRequiredScore() + (1.0f - this.getRouter().getRequiredScore()) * ((float)matchedLength / totalLength) : 1.0f;
            }
            if (request.isLoggable() && this.getLogger().isLoggable(Level.FINER)) {
                this.getLogger().finer("Call score for the \"" + this.getTemplate().getPattern() + "\" URI pattern: " + result);
            }
        }
        return result;
    }

    public void setMatchingMode(int matchingMode) {
        this.getTemplate().setMatchingMode(matchingMode);
    }

    public void setMatchingQuery(boolean matchingQuery) {
        this.matchingQuery = matchingQuery;
    }

    public void setTemplate(Template template) {
        this.template = template;
    }

    public String toString() {
        return "\"" + (this.getTemplate() == null ? super.toString() : this.getTemplate().getPattern()) + "\" -> " + (this.getNext() == null ? "null" : this.getNext().toString());
    }
}

