/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.application;

import java.util.logging.Level;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.Status;
import org.restlet.routing.Filter;
import org.restlet.service.StatusService;

public class StatusFilter
extends Filter {
    private volatile boolean overwriting;
    private volatile StatusService statusService;

    public StatusFilter(Context context, boolean overwriting) {
        super(context);
        this.overwriting = overwriting;
        this.statusService = null;
    }

    public StatusFilter(Context context, StatusService statusService) {
        this(context, statusService.isOverwriting());
        this.statusService = statusService;
    }

    @Override
    public void afterHandle(Request request, Response response) {
        if (response.getStatus() == null) {
            response.setStatus(Status.SUCCESS_OK);
        }
        try {
            if (response.getStatus().isError() && (response.getEntity() == null || this.isOverwriting())) {
                response.setEntity(this.getStatusService().toRepresentation(response.getStatus(), request, response));
            }
        }
        catch (Exception e) {
            this.getLogger().log(Level.WARNING, "Unable to get the custom status representation", e);
        }
    }

    @Override
    protected int doHandle(Request request, Response response) {
        block7: {
            try {
                super.doHandle(request, response);
            }
            catch (Throwable throwable) {
                Status status = this.getStatusService().toStatus(throwable, request, response);
                Level level = Level.INFO;
                if (status.isServerError()) {
                    level = Level.WARNING;
                } else if (status.isConnectorError()) {
                    level = Level.INFO;
                } else if (status.isClientError()) {
                    level = Level.FINE;
                }
                this.getLogger().log(level, "Exception or error caught by status service", throwable);
                if (response == null) break block7;
                response.setStatus(status);
            }
        }
        return 0;
    }

    public StatusService getStatusService() {
        return this.statusService;
    }

    public boolean isOverwriting() {
        return this.overwriting;
    }

    public void setOverwriting(boolean overwriting) {
        this.overwriting = overwriting;
    }

    public void setStatusService(StatusService statusService) {
        this.statusService = statusService;
    }
}

