/*
 * Decompiled with CFR 0.152.
 */
package org.revenj;

import java.io.IOException;
import java.lang.reflect.Type;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.revenj.Utils;
import org.revenj.extensibility.Container;
import org.revenj.patterns.AggregateRoot;
import org.revenj.patterns.DataChangeNotification;
import org.revenj.patterns.DataContext;
import org.revenj.patterns.DataSource;
import org.revenj.patterns.DomainEvent;
import org.revenj.patterns.DomainEventStore;
import org.revenj.patterns.Identifiable;
import org.revenj.patterns.PersistableRepository;
import org.revenj.patterns.Query;
import org.revenj.patterns.Report;
import org.revenj.patterns.Repository;
import org.revenj.patterns.SearchableRepository;
import org.revenj.patterns.Specification;
import org.revenj.patterns.UnitOfWork;
import rx.Observable;

final class LocatorDataContext
implements UnitOfWork {
    private final Container locator;
    private ConcurrentHashMap<Class<?>, SearchableRepository> repositories;
    private ConcurrentHashMap<Class<?>, DomainEventStore> eventStores;
    private DataChangeNotification changes;
    private final Connection connection;
    private boolean hasChanges;
    private boolean closed;

    LocatorDataContext(Container locator, Connection connection) {
        this.locator = locator;
        this.connection = connection;
    }

    static DataContext asDataContext(Container container) {
        return new LocatorDataContext(container, null);
    }

    static UnitOfWork asUnitOfWork(Container container) {
        javax.sql.DataSource dataSource = container.resolve(javax.sql.DataSource.class);
        Container locator = container.createScope();
        Connection connection = null;
        try {
            connection = dataSource.getConnection();
            connection.setAutoCommit(false);
        }
        catch (SQLException e) {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException ignore) {
                // empty catch block
            }
            try {
                connection = dataSource.getConnection();
                connection.setAutoCommit(false);
            }
            catch (SQLException ex) {
                throw new RuntimeException(ex);
            }
        }
        locator.registerInstance((Type)((Object)Connection.class), connection, false);
        return new LocatorDataContext(locator, connection);
    }

    private SearchableRepository getRepository(Class<?> manifest) {
        if (this.closed) {
            throw new RuntimeException("Unit of work has been closed");
        }
        if (this.repositories == null) {
            this.repositories = new ConcurrentHashMap();
        }
        return this.repositories.computeIfAbsent(manifest, clazz2 -> {
            try {
                return (SearchableRepository)this.locator.resolve(Utils.makeGenericType(SearchableRepository.class, manifest, new Type[0]));
            }
            catch (ReflectiveOperationException ex) {
                throw new RuntimeException("Repository is not registered for: " + manifest, ex);
            }
        });
    }

    private DomainEventStore getEventStore(Class<?> manifest) {
        if (this.closed) {
            throw new RuntimeException("Unit of work has been closed");
        }
        if (this.eventStores == null) {
            this.eventStores = new ConcurrentHashMap();
        }
        return this.eventStores.computeIfAbsent(manifest, clazz2 -> {
            try {
                return (DomainEventStore)this.locator.resolve(Utils.makeGenericType(SearchableRepository.class, manifest, new Type[0]));
            }
            catch (ReflectiveOperationException ex) {
                throw new RuntimeException("Domain event store is not registered for: " + manifest, ex);
            }
        });
    }

    @Override
    public <T extends Identifiable> Optional<T> find(Class<T> manifest, String uri) {
        return ((Repository)this.getRepository(manifest)).find(uri);
    }

    @Override
    public <T extends Identifiable> List<T> find(Class<T> manifest, Collection<String> uris) {
        return ((Repository)this.getRepository(manifest)).find(uris);
    }

    @Override
    public <T extends DataSource> Query<T> query(Class<T> manifest, Specification<T> filter) {
        return this.getRepository(manifest).query(filter);
    }

    @Override
    public <T extends DataSource> List<T> search(Class<T> manifest, Specification<T> filter, Integer limit, Integer offset) {
        return this.getRepository(manifest).search(filter, limit, offset);
    }

    @Override
    public <T extends DataSource> long count(Class<T> manifest, Specification<T> filter) {
        return this.getRepository(manifest).count(filter);
    }

    @Override
    public <T extends DataSource> boolean exists(Class<T> manifest, Specification<T> filter) {
        return this.getRepository(manifest).exists(filter);
    }

    @Override
    public <T extends AggregateRoot> void create(Collection<T> aggregates) throws IOException {
        if (aggregates.size() == 0) {
            return;
        }
        Class<?> manifest = ((AggregateRoot)aggregates.iterator().next()).getClass();
        ((PersistableRepository)this.getRepository(manifest)).insert(aggregates);
        this.hasChanges = true;
    }

    @Override
    public <T extends AggregateRoot> void update(Collection<Map.Entry<T, T>> pairs) throws IOException {
        if (pairs.size() == 0) {
            return;
        }
        Class<?> manifest = ((AggregateRoot)pairs.iterator().next().getValue()).getClass();
        ((PersistableRepository)this.getRepository(manifest)).update(pairs);
        this.hasChanges = true;
    }

    @Override
    public <T extends AggregateRoot> void delete(Collection<T> aggregates) throws IOException {
        if (aggregates.size() == 0) {
            return;
        }
        Class<?> manifest = ((AggregateRoot)aggregates.iterator().next()).getClass();
        ((PersistableRepository)this.getRepository(manifest)).insert(aggregates);
        this.hasChanges = true;
    }

    @Override
    public <T extends DomainEvent> void submit(Collection<T> events) {
        if (events.size() == 0) {
            return;
        }
        Class<?> manifest = ((DomainEvent)events.iterator().next()).getClass();
        this.getEventStore(manifest).submit(events);
        this.hasChanges = true;
    }

    @Override
    public <T> T populate(Report<T> report) {
        return report.populate(this.locator);
    }

    @Override
    public <T extends Identifiable> Observable<DataChangeNotification.TrackInfo<T>> track(Class<T> manifest) {
        if (this.changes == null) {
            this.changes = this.locator.resolve(DataChangeNotification.class);
        }
        return this.changes.track(manifest);
    }

    @Override
    public void commit() {
        if (this.hasChanges) {
            try {
                this.connection.commit();
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
        this.hasChanges = false;
    }

    @Override
    public void rollback() {
        try {
            this.connection.rollback();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        this.hasChanges = false;
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        if (this.hasChanges) {
            this.rollback();
        }
        try {
            this.connection.setAutoCommit(true);
            this.connection.close();
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
        try {
            this.locator.close();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        this.closed = true;
    }
}

