/*
 * Decompiled with CFR 0.152.
 */
package org.revenj.patterns;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Arrays;

public final class Bytes {
    public final byte[] content;
    public final int length;
    public static final Bytes EMPTY = Bytes.from(new byte[0]);
    private static final Charset utf8 = Charset.forName("UTF-8");

    public Bytes(byte[] content, int length) {
        this.content = content;
        this.length = length;
    }

    public static Bytes from(byte[] content) {
        return new Bytes(content, content.length);
    }

    public void copyTo(OutputStream stream) throws IOException {
        stream.write(this.content, 0, this.length);
    }

    public ByteArrayInputStream toStream() {
        return new ByteArrayInputStream(this.content, 0, this.length);
    }

    public String toUtf8() {
        return new String(this.content, 0, this.length, utf8);
    }

    public byte[] toByteArray() {
        return Arrays.copyOf(this.content, this.length);
    }
}

