/*
 * Decompiled with CFR 0.152.
 */
package org.revenj.postgres.converters;

import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.List;
import javax.swing.text.Segment;
import org.postgresql.util.PGobject;
import org.revenj.postgres.PostgresBuffer;
import org.revenj.postgres.PostgresReader;
import org.revenj.postgres.PostgresWriter;
import org.revenj.postgres.converters.NumberConverter;
import org.revenj.postgres.converters.PostgresTuple;

public abstract class TimestampConverter {
    private static final LocalDateTime MIN_LOCAL_DATE_TIME = LocalDateTime.of(1, 1, 1, 0, 0, 0, 0);
    private static final OffsetDateTime MIN_DATE_TIME_UTC = OffsetDateTime.of(MIN_LOCAL_DATE_TIME, ZoneOffset.UTC);
    private static final int[] TIMESTAMP_REMINDER = new int[]{100000, 10000, 1000, 100, 10, 1};

    public static void setParameter(PostgresBuffer sw, PreparedStatement ps, int index, LocalDateTime value) throws SQLException {
        PGobject pg = new PGobject();
        pg.setType("timestamptz");
        char[] buf = sw.getTempBuffer();
        int len = TimestampConverter.serialize(buf, 0, value);
        pg.setValue(new String(buf, 0, len));
        ps.setObject(index, pg);
    }

    public static void setParameter(PostgresBuffer sw, PreparedStatement ps, int index, OffsetDateTime value) throws SQLException {
        PGobject pg = new PGobject();
        pg.setType("timestamptz");
        char[] buf = sw.getTempBuffer();
        int len = TimestampConverter.serialize(buf, 0, value);
        pg.setValue(new String(buf, 0, len));
        ps.setObject(index, pg);
    }

    public static void serializeURI(PostgresBuffer sw, LocalDateTime value) {
        int len = TimestampConverter.serialize(sw.getTempBuffer(), 0, value);
        sw.addToBuffer(sw.getTempBuffer(), len);
    }

    private static int serialize(char[] buffer, int pos, LocalDateTime value) {
        buffer[pos + 4] = 45;
        buffer[pos + 7] = 45;
        buffer[pos + 10] = 32;
        buffer[pos + 13] = 58;
        buffer[pos + 16] = 58;
        NumberConverter.write4(value.getYear(), buffer, pos);
        NumberConverter.write2(value.getMonthValue(), buffer, pos + 5);
        NumberConverter.write2(value.getDayOfMonth(), buffer, pos + 8);
        NumberConverter.write2(value.getHour(), buffer, pos + 11);
        NumberConverter.write2(value.getMinute(), buffer, pos + 14);
        NumberConverter.write2(value.getSecond(), buffer, pos + 17);
        int micro = value.getNano() / 1000;
        int end = pos + 19;
        if (micro != 0) {
            buffer[pos + 19] = 46;
            int div = micro / 100;
            int rem = micro - div * 100;
            NumberConverter.write4(div, buffer, 20);
            NumberConverter.write2(rem, buffer, 24);
            end = pos + 25;
            while (buffer[end] == '0') {
                --end;
            }
            ++end;
        }
        buffer[end] = 43;
        buffer[end + 1] = 48;
        buffer[end + 2] = 48;
        return end + 3;
    }

    public static int serialize(char[] buffer, int pos, OffsetDateTime value) {
        int offsetHours;
        int offset = value.getOffset().getTotalSeconds();
        int offsetDiff = offset - (offsetHours = offset / 3600) * 3600;
        if (offsetDiff != 0) {
            return TimestampConverter.serialize(buffer, pos, value.plusSeconds(offsetDiff));
        }
        buffer[pos + 4] = 45;
        buffer[pos + 7] = 45;
        buffer[pos + 10] = 32;
        buffer[pos + 13] = 58;
        buffer[pos + 16] = 58;
        NumberConverter.write4(value.getYear(), buffer, pos);
        NumberConverter.write2(value.getMonthValue(), buffer, pos + 5);
        NumberConverter.write2(value.getDayOfMonth(), buffer, pos + 8);
        NumberConverter.write2(value.getHour(), buffer, pos + 11);
        NumberConverter.write2(value.getMinute(), buffer, pos + 14);
        NumberConverter.write2(value.getSecond(), buffer, pos + 17);
        int micro = value.getNano() / 1000;
        int end = pos + 19;
        if (micro != 0) {
            buffer[pos + 19] = 46;
            int div = micro / 100;
            int rem = micro - div * 100;
            NumberConverter.write4(div, buffer, 20);
            NumberConverter.write2(rem, buffer, 24);
            end = pos + 25;
            while (buffer[end] == '0') {
                --end;
            }
            ++end;
        }
        if (offsetHours >= 0) {
            buffer[end] = 43;
            NumberConverter.write2(offsetHours, buffer, end + 1);
        } else {
            buffer[end] = 45;
            NumberConverter.write2(-offsetHours, buffer, end + 1);
        }
        return end + 3;
    }

    public static LocalDateTime parseLocal(PostgresReader reader, int context, boolean allowNulls) throws IOException {
        int cur = reader.read();
        if (cur == 44 || cur == 41) {
            return allowNulls ? null : MIN_LOCAL_DATE_TIME;
        }
        LocalDateTime res = TimestampConverter.parseLocalTimestamp(reader, context);
        reader.read();
        return res;
    }

    public static OffsetDateTime parseOffset(PostgresReader reader, int context, boolean allowNulls, boolean asUtc) throws IOException {
        int cur = reader.read();
        if (cur == 44 || cur == 41) {
            return allowNulls ? null : MIN_DATE_TIME_UTC;
        }
        OffsetDateTime res = TimestampConverter.parseOffsetTimestamp(reader, context, asUtc);
        reader.read();
        return res;
    }

    private static LocalDateTime parseLocalTimestamp(PostgresReader reader, int context) throws IOException {
        int cur = reader.read(context);
        char[] buf = reader.tmp;
        buf[0] = (char)cur;
        int len = reader.fillUntil(buf, 1, '\\', '\"') + 1;
        reader.read(context);
        if (buf[10] != ' ') {
            return LocalDateTime.parse(new Segment(buf, 0, len));
        }
        int year = NumberConverter.read4(buf, 0);
        int month = NumberConverter.read2(buf, 5);
        int date = NumberConverter.read2(buf, 8);
        int hour = NumberConverter.read2(buf, 11);
        int minutes = NumberConverter.read2(buf, 14);
        int seconds = NumberConverter.read2(buf, 17);
        if (buf[19] == '.') {
            int nano = 0;
            int max = len - 3;
            int i = 20;
            for (int r = 0; i < max && r < TIMESTAMP_REMINDER.length; ++i, ++r) {
                nano += TIMESTAMP_REMINDER[r] * (buf[i] - 48);
            }
            boolean pos = buf[len - 3] == '+';
            int offset = NumberConverter.read2(buf, len - 2);
            return offset != 0 ? LocalDateTime.of(year, month, date, hour, minutes, seconds, nano * 1000).plusHours(pos ? (long)(-offset) : (long)offset) : LocalDateTime.of(year, month, date, hour, minutes, seconds, nano * 1000);
        }
        boolean pos = buf[len - 3] == '+';
        int offset = NumberConverter.read2(buf, len - 2);
        return offset != 0 ? LocalDateTime.of(year, month, date, hour, minutes, seconds).plusHours(pos ? (long)(-offset) : (long)offset) : LocalDateTime.of(year, month, date, hour, minutes, seconds);
    }

    private static OffsetDateTime parseOffsetTimestamp(PostgresReader reader, int context, boolean asUtc) throws IOException {
        int cur = reader.read(context);
        char[] buf = reader.tmp;
        buf[0] = (char)cur;
        int len = reader.fillUntil(buf, 1, '\\', '\"') + 1;
        reader.read(context);
        if (buf[10] != ' ') {
            return OffsetDateTime.parse(new Segment(buf, 0, len));
        }
        int year = NumberConverter.read4(buf, 0);
        int month = NumberConverter.read2(buf, 5);
        int date = NumberConverter.read2(buf, 8);
        int hour = NumberConverter.read2(buf, 11);
        int minutes = NumberConverter.read2(buf, 14);
        int seconds = NumberConverter.read2(buf, 17);
        if (buf[19] == '.') {
            int nano = 0;
            int max = len - 3;
            int i = 20;
            for (int r = 0; i < max && r < TIMESTAMP_REMINDER.length; ++i, ++r) {
                nano += TIMESTAMP_REMINDER[r] * (buf[i] - 48);
            }
            boolean pos = buf[len - 3] == '+';
            int offset = NumberConverter.read2(buf, len - 2);
            return asUtc ? OffsetDateTime.of(year, month, date, hour, minutes, seconds, nano * 1000, ZoneOffset.UTC).plusHours(pos ? (long)(-offset) : (long)offset) : (offset != 0 ? OffsetDateTime.of(year, month, date, hour, minutes, seconds, nano * 1000, ZoneOffset.ofHours(pos ? offset : -offset)) : OffsetDateTime.of(year, month, date, hour, minutes, seconds, nano * 1000, ZoneOffset.UTC));
        }
        boolean pos = buf[len - 3] == '+';
        int offset = NumberConverter.read2(buf, len - 2);
        return asUtc ? OffsetDateTime.of(year, month, date, hour, minutes, seconds, 0, ZoneOffset.UTC).plusHours(pos ? (long)(-offset) : (long)offset) : (offset != 0 ? OffsetDateTime.of(year, month, date, hour, minutes, seconds, 0, ZoneOffset.ofHours(pos ? offset : -offset)) : OffsetDateTime.of(year, month, date, hour, minutes, seconds, 0, ZoneOffset.UTC));
    }

    public static List<LocalDateTime> parseLocalCollection(PostgresReader reader, int context, boolean allowNulls) throws IOException {
        LocalDateTime defaultValue;
        boolean escaped;
        int cur = reader.read();
        if (cur == 44 || cur == 41) {
            return null;
        }
        boolean bl = escaped = cur != 123;
        if (escaped) {
            reader.read(context);
        }
        int innerContext = context == 0 ? 1 : context << 1;
        cur = reader.peek();
        if (cur == 125) {
            if (escaped) {
                reader.read(context + 2);
            } else {
                reader.read(2);
            }
            return new ArrayList<LocalDateTime>(0);
        }
        ArrayList<LocalDateTime> list = new ArrayList<LocalDateTime>();
        LocalDateTime localDateTime = defaultValue = allowNulls ? null : MIN_LOCAL_DATE_TIME;
        do {
            if ((cur = reader.read()) == 78) {
                cur = reader.read(4);
                list.add(defaultValue);
                continue;
            }
            list.add(TimestampConverter.parseLocalTimestamp(reader, innerContext));
            cur = reader.read();
        } while (cur == 44);
        if (escaped) {
            reader.read(context + 1);
        } else {
            reader.read();
        }
        return list;
    }

    public static List<OffsetDateTime> parseOffsetCollection(PostgresReader reader, int context, boolean allowNulls, boolean asUtc) throws IOException {
        OffsetDateTime defaultValue;
        boolean escaped;
        int cur = reader.read();
        if (cur == 44 || cur == 41) {
            return null;
        }
        boolean bl = escaped = cur != 123;
        if (escaped) {
            reader.read(context);
        }
        int innerContext = context == 0 ? 1 : context << 1;
        cur = reader.peek();
        if (cur == 125) {
            if (escaped) {
                reader.read(context + 2);
            } else {
                reader.read(2);
            }
            return new ArrayList<OffsetDateTime>(0);
        }
        ArrayList<OffsetDateTime> list = new ArrayList<OffsetDateTime>();
        OffsetDateTime offsetDateTime = defaultValue = allowNulls ? null : MIN_DATE_TIME_UTC;
        do {
            if ((cur = reader.read()) == 78) {
                cur = reader.read(4);
                list.add(defaultValue);
                continue;
            }
            list.add(TimestampConverter.parseOffsetTimestamp(reader, innerContext, asUtc));
            cur = reader.read();
        } while (cur == 44);
        if (escaped) {
            reader.read(context + 1);
        } else {
            reader.read();
        }
        return list;
    }

    public static PostgresTuple toTuple(LocalDateTime value) {
        if (value == null) {
            return null;
        }
        return new LocalTimestampTuple(value);
    }

    public static PostgresTuple toTuple(OffsetDateTime value) {
        if (value == null) {
            return null;
        }
        return new OffsetTimestampTuple(value);
    }

    static class OffsetTimestampTuple
    extends PostgresTuple {
        private final OffsetDateTime value;

        public OffsetTimestampTuple(OffsetDateTime value) {
            this.value = value;
        }

        @Override
        public boolean mustEscapeRecord() {
            return true;
        }

        @Override
        public boolean mustEscapeArray() {
            return true;
        }

        @Override
        public void insertRecord(PostgresWriter sw, String escaping, PostgresTuple.Mapping mappings) {
            int len = TimestampConverter.serialize(sw.tmp, 0, this.value);
            sw.write(sw.tmp, 0, len);
        }

        @Override
        public void insertArray(PostgresWriter sw, String escaping, PostgresTuple.Mapping mappings) {
            this.insertRecord(sw, escaping, mappings);
        }

        @Override
        public String buildTuple(boolean quote) {
            char[] buf = new char[32];
            if (quote) {
                buf[0] = 39;
                int len = TimestampConverter.serialize(buf, 1, this.value);
                buf[len] = 39;
                return new String(buf, 0, len + 1);
            }
            int len = TimestampConverter.serialize(buf, 1, this.value);
            return new String(buf, 0, len);
        }
    }

    static class LocalTimestampTuple
    extends PostgresTuple {
        private final LocalDateTime value;

        public LocalTimestampTuple(LocalDateTime value) {
            this.value = value;
        }

        @Override
        public boolean mustEscapeRecord() {
            return true;
        }

        @Override
        public boolean mustEscapeArray() {
            return true;
        }

        @Override
        public void insertRecord(PostgresWriter sw, String escaping, PostgresTuple.Mapping mappings) {
            int len = TimestampConverter.serialize(sw.tmp, 0, this.value);
            sw.writeBuffer(len);
        }

        @Override
        public void insertArray(PostgresWriter sw, String escaping, PostgresTuple.Mapping mappings) {
            this.insertRecord(sw, escaping, mappings);
        }

        @Override
        public String buildTuple(boolean quote) {
            char[] buf = new char[32];
            if (quote) {
                buf[0] = 39;
                int len = TimestampConverter.serialize(buf, 1, this.value);
                buf[len] = 39;
                return new String(buf, 0, len + 1);
            }
            int len = TimestampConverter.serialize(buf, 1, this.value);
            return new String(buf, 0, len);
        }
    }
}

