/*
 * Decompiled with CFR 0.152.
 */
package org.revenj.postgres.jinq;

import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import java.util.Optional;
import org.revenj.patterns.DataSource;
import org.revenj.patterns.Query;
import org.revenj.patterns.Specification;
import org.revenj.postgres.jinq.RevenjQueryComposer;

final class RevenjQuery<T extends DataSource>
implements Query<T> {
    private final RevenjQueryComposer<T> queryComposer;

    public RevenjQuery(RevenjQueryComposer<T> query) {
        this.queryComposer = query;
    }

    static <U extends DataSource> RevenjQuery<U> makeQueryStream(RevenjQueryComposer<U> query) {
        return new RevenjQuery<U>(query);
    }

    @Override
    public Query<T> filter(Specification<T> predicate) {
        if (predicate == null) {
            return this;
        }
        RevenjQueryComposer<T> newComposer = this.queryComposer.where(predicate);
        return RevenjQuery.makeQueryStream(newComposer);
    }

    @Override
    public Query<T> skip(long n) {
        RevenjQueryComposer<T> newComposer = this.queryComposer.skip(n);
        return RevenjQuery.makeQueryStream(newComposer);
    }

    @Override
    public Query<T> limit(long n) {
        RevenjQueryComposer<T> newComposer = this.queryComposer.limit(n);
        return RevenjQuery.makeQueryStream(newComposer);
    }

    @Override
    public <V extends Comparable<V>> Query<T> sortedBy(Query.Compare<T, V> order) {
        RevenjQueryComposer<T> newComposer = this.queryComposer.sortedBy(order, true);
        return RevenjQuery.makeQueryStream(newComposer);
    }

    @Override
    public <V extends Comparable<V>> Query<T> sortedDescendingBy(Query.Compare<T, V> order) {
        RevenjQueryComposer<T> newComposer = this.queryComposer.sortedBy(order, false);
        return RevenjQuery.makeQueryStream(newComposer);
    }

    @Override
    public long count() throws IOException {
        try {
            return this.queryComposer.count();
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    @Override
    public boolean anyMatch(Specification<? super T> predicate) throws IOException {
        try {
            return predicate != null ? this.queryComposer.where(predicate).any() : this.queryComposer.any();
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    @Override
    public boolean allMatch(Specification<? super T> predicate) throws IOException {
        try {
            return this.queryComposer.all(predicate);
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    @Override
    public boolean noneMatch(Specification<? super T> predicate) throws IOException {
        try {
            return predicate != null ? this.queryComposer.where(predicate).none() : this.queryComposer.none();
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    @Override
    public Optional<T> findFirst() throws IOException {
        try {
            return this.queryComposer.first();
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    @Override
    public Optional<T> findAny() throws IOException {
        try {
            return this.queryComposer.first();
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    @Override
    public List<T> list() throws IOException {
        try {
            return this.queryComposer.toList();
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }
}

