/*
 * Decompiled with CFR 0.152.
 */
package org.revenj.postgres.jinq.jpqlquery;

import java.util.ArrayList;
import java.util.List;
import org.revenj.postgres.jinq.jpqlquery.Expression;
import org.revenj.postgres.jinq.jpqlquery.ExpressionVisitor;
import org.revenj.postgres.jinq.jpqlquery.OperatorPrecedenceLevel;
import org.revenj.postgres.jinq.jpqlquery.QueryGenerationState;

public class FunctionExpression
extends Expression {
    final List<Expression> arguments = new ArrayList<Expression>(3);
    String functionName;

    public static FunctionExpression singleParam(String name, Expression base) {
        FunctionExpression func = new FunctionExpression();
        func.arguments.add(base);
        func.functionName = name;
        return func;
    }

    public static FunctionExpression twoParam(String name, Expression param1, Expression param2) {
        FunctionExpression func = new FunctionExpression();
        func.arguments.add(param1);
        func.arguments.add(param2);
        func.functionName = name;
        return func;
    }

    public static FunctionExpression threeParam(String name, Expression param1, Expression param2, Expression param3) {
        FunctionExpression func = new FunctionExpression();
        func.arguments.add(param1);
        func.arguments.add(param2);
        func.arguments.add(param3);
        func.functionName = name;
        return func;
    }

    @Override
    public void generateQuery(QueryGenerationState queryState, OperatorPrecedenceLevel operatorPrecedenceScope) {
        queryState.appendQuery(this.functionName);
        queryState.appendQuery("(");
        this.arguments.get(0).generateQuery(queryState, OperatorPrecedenceLevel.JPQL_UNRESTRICTED_OPERATOR_PRECEDENCE);
        for (int i = 1; i < this.arguments.size(); ++i) {
            queryState.appendQuery(", ");
            this.arguments.get(i).generateQuery(queryState, OperatorPrecedenceLevel.JPQL_UNRESTRICTED_OPERATOR_PRECEDENCE);
        }
        queryState.appendQuery(")");
    }

    @Override
    public void prepareQueryGeneration(Expression.QueryGenerationPreparationPhase preparePhase, QueryGenerationState queryState) {
        for (Expression arg : this.arguments) {
            arg.prepareQueryGeneration(preparePhase, queryState);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        FunctionExpression o = (FunctionExpression)obj;
        if (!this.functionName.equals(o.functionName)) {
            return false;
        }
        if (this.arguments.size() != o.arguments.size()) {
            return false;
        }
        for (int n = 0; n < this.arguments.size(); ++n) {
            if (this.arguments.get(n).equals(o.arguments.get(n))) continue;
            return false;
        }
        return true;
    }

    @Override
    public void visit(ExpressionVisitor visitor) {
        visitor.visitFunction(this);
    }
}

