/*
 * Decompiled with CFR 0.152.
 */
package org.revenj.postgres.jinq.transform;

import ch.epfl.labos.iu.orm.queryll2.path.Annotations;
import ch.epfl.labos.iu.orm.queryll2.path.PathAnalysisMethodChecker;
import ch.epfl.labos.iu.orm.queryll2.path.TransformationClassAnalyzer;
import ch.epfl.labos.iu.orm.queryll2.symbolic.BasicSymbolicInterpreter;
import ch.epfl.labos.iu.orm.queryll2.symbolic.MethodSignature;
import ch.epfl.labos.iu.orm.queryll2.symbolic.TypedValue;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import org.jinq.orm.stream.JinqStream;
import org.revenj.postgres.jinq.transform.MethodHandlerStatic;
import org.revenj.postgres.jinq.transform.MethodHandlerVirtual;

class MethodChecker
implements PathAnalysisMethodChecker {
    private final Set<Class<?>> safeMethodAnnotations;
    private final Set<MethodSignature> safeMethods;
    private final Set<MethodSignature> safeStaticMethods;
    private final boolean isObjectEqualsSafe;
    private final boolean isCollectionContainsSafe;
    public static final MethodSignature objectEquals = new MethodSignature("java/lang/Object", "equals", "(Ljava/lang/Object;)Z");
    static final Map<MethodSignature, MethodHandlerVirtual> jpqlFunctionMethods;
    static final Map<MethodSignature, MethodHandlerStatic> jpqlFunctionStaticMethods;
    public static final MethodSignature streamSumInt;
    public static final MethodSignature streamSumDouble;
    public static final MethodSignature streamSumLong;
    public static final MethodSignature streamSumBigDecimal;
    public static final MethodSignature streamSumBigInteger;
    public static final MethodSignature streamMax;
    public static final MethodSignature streamMin;
    public static final MethodSignature streamAvg;
    public static final MethodSignature streamCount;
    public static final MethodSignature streamDistinct;
    public static final MethodSignature streamSelect;
    public static final MethodSignature streamSelectAll;
    public static final MethodSignature streamSelectAllList;
    public static final MethodSignature streamWhere;
    public static final MethodSignature streamJoin;
    public static final MethodSignature streamJoinList;
    public static final MethodSignature streamGetOnlyValue;
    private static final Set<MethodSignature> subqueryMethods;

    MethodChecker(Set<Class<?>> safeMethodAnnotations, Set<MethodSignature> safeMethods, Set<MethodSignature> safeStaticMethods, boolean isObjectEqualsSafe, boolean isCollectionContainsSafe) {
        this.safeMethodAnnotations = safeMethodAnnotations;
        this.safeMethods = safeMethods;
        this.safeStaticMethods = safeStaticMethods;
        this.isObjectEqualsSafe = isObjectEqualsSafe;
        this.isCollectionContainsSafe = isCollectionContainsSafe;
    }

    public BasicSymbolicInterpreter.OperationSideEffect isStaticMethodSafe(MethodSignature m) {
        return this.safeStaticMethods.contains(m) || jpqlFunctionStaticMethods.containsKey(m) ? BasicSymbolicInterpreter.OperationSideEffect.NONE : BasicSymbolicInterpreter.OperationSideEffect.UNSAFE;
    }

    public BasicSymbolicInterpreter.OperationSideEffect isMethodSafe(MethodSignature m, TypedValue base, List<TypedValue> args) {
        if (this.isObjectEqualsSafe && objectEquals.equals((Object)m)) {
            return BasicSymbolicInterpreter.OperationSideEffect.NONE;
        }
        if (this.safeMethods.contains(m) || subqueryMethods.contains(m) || jpqlFunctionMethods.containsKey(m)) {
            return BasicSymbolicInterpreter.OperationSideEffect.NONE;
        }
        try {
            Method reflectedMethod = Annotations.asmMethodSignatureToReflectionMethod((MethodSignature)m);
            if (this.isCollectionContainsSafe && "contains".equals(m.name) && "(Ljava/lang/Object;)Z".equals(m.desc) && Collection.class.isAssignableFrom(reflectedMethod.getDeclaringClass())) {
                return BasicSymbolicInterpreter.OperationSideEffect.NONE;
            }
            if (Annotations.methodHasSomeAnnotations((Method)reflectedMethod, this.safeMethodAnnotations)) {
                return BasicSymbolicInterpreter.OperationSideEffect.NONE;
            }
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            // empty catch block
        }
        return BasicSymbolicInterpreter.OperationSideEffect.UNSAFE;
    }

    public boolean isFluentChaining(MethodSignature sig) {
        return TransformationClassAnalyzer.stringBuilderAppendString.equals((Object)sig);
    }

    public boolean isPutFieldAllowed() {
        return false;
    }

    static {
        try {
            streamSelectAll = MethodSignature.fromMethod((Method)JinqStream.class.getMethod("selectAll", JinqStream.Join.class));
            streamSelectAllList = MethodSignature.fromMethod((Method)JinqStream.class.getMethod("selectAllList", JinqStream.JoinToIterable.class));
            streamJoinList = MethodSignature.fromMethod((Method)JinqStream.class.getMethod("joinList", JinqStream.JoinToIterable.class));
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new IllegalArgumentException("Cannot initialize MethodChecker because it cannot find a needed method", e);
        }
        jpqlFunctionMethods = new HashMap<MethodSignature, MethodHandlerVirtual>();
        jpqlFunctionStaticMethods = new HashMap<MethodSignature, MethodHandlerStatic>();
        ServiceLoader<MethodHandlerStatic> staticHandlers = ServiceLoader.load(MethodHandlerStatic.class);
        for (MethodHandlerStatic handler : staticHandlers) {
            try {
                for (MethodSignature methodSignature : handler.getSupportedSignatures()) {
                    jpqlFunctionStaticMethods.put(methodSignature, handler);
                }
            }
            catch (NoSuchMethodException ex) {
                ex.printStackTrace();
            }
        }
        ServiceLoader<MethodHandlerVirtual> virtualHandlers = ServiceLoader.load(MethodHandlerVirtual.class);
        for (MethodHandlerVirtual handler : virtualHandlers) {
            try {
                for (MethodSignature signature : handler.getSupportedSignatures()) {
                    jpqlFunctionMethods.put(signature, handler);
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                noSuchMethodException.printStackTrace();
            }
        }
        streamSumInt = TransformationClassAnalyzer.streamSumInt;
        streamSumDouble = TransformationClassAnalyzer.streamSumDouble;
        streamSumLong = new MethodSignature("org/jinq/orm/stream/JinqStream", "sumLong", "(Lorg/jinq/orm/stream/JinqStream$CollectLong;)Ljava/lang/Long;");
        streamSumBigDecimal = new MethodSignature("org/jinq/orm/stream/JinqStream", "sumBigDecimal", "(Lorg/jinq/orm/stream/JinqStream$CollectBigDecimal;)Ljava/math/BigDecimal;");
        streamSumBigInteger = new MethodSignature("org/jinq/orm/stream/JinqStream", "sumBigInteger", "(Lorg/jinq/orm/stream/JinqStream$CollectBigInteger;)Ljava/math/BigInteger;");
        streamMax = TransformationClassAnalyzer.streamMax;
        streamMin = TransformationClassAnalyzer.streamMin;
        streamAvg = new MethodSignature("org/jinq/orm/stream/JinqStream", "avg", "(Lorg/jinq/orm/stream/JinqStream$CollectNumber;)Ljava/lang/Double;");
        streamCount = new MethodSignature("org/jinq/orm/stream/JinqStream", "count", "()J");
        streamDistinct = new MethodSignature("org/jinq/orm/stream/JinqStream", "distinct", "()Lorg/jinq/orm/stream/JinqStream;");
        streamSelect = new MethodSignature("org/jinq/orm/stream/JinqStream", "select", "(Lorg/jinq/orm/stream/JinqStream$Select;)Lorg/jinq/orm/stream/JinqStream;");
        streamWhere = new MethodSignature("org/jinq/orm/stream/JinqStream", "where", "(Lorg/jinq/orm/stream/JinqStream$Where;)Lorg/jinq/orm/stream/JinqStream;");
        streamJoin = new MethodSignature("org/jinq/orm/stream/JinqStream", "join", "(Lorg/jinq/orm/stream/JinqStream$Join;)Lorg/jinq/orm/stream/JinqStream;");
        streamGetOnlyValue = new MethodSignature("org/jinq/orm/stream/JinqStream", "getOnlyValue", "()Ljava/lang/Object;");
        subqueryMethods = new HashSet<MethodSignature>();
        subqueryMethods.add(streamSumInt);
        subqueryMethods.add(streamSumDouble);
        subqueryMethods.add(streamSumLong);
        subqueryMethods.add(streamSumBigInteger);
        subqueryMethods.add(streamSumBigDecimal);
        subqueryMethods.add(streamMax);
        subqueryMethods.add(streamMin);
        subqueryMethods.add(streamAvg);
        subqueryMethods.add(streamCount);
        subqueryMethods.add(streamDistinct);
        subqueryMethods.add(streamSelect);
        subqueryMethods.add(streamSelectAll);
        subqueryMethods.add(streamSelectAllList);
        subqueryMethods.add(streamWhere);
        subqueryMethods.add(streamJoin);
        subqueryMethods.add(streamJoinList);
        subqueryMethods.add(streamGetOnlyValue);
    }
}

