/*
 * Decompiled with CFR 0.152.
 */
package org.revenj.postgres.jinq.transform;

import ch.epfl.labos.iu.orm.queryll2.path.PathAnalysis;
import ch.epfl.labos.iu.orm.queryll2.path.PathAnalysisSimplifier;
import ch.epfl.labos.iu.orm.queryll2.symbolic.TypedValue;
import ch.epfl.labos.iu.orm.queryll2.symbolic.TypedValueVisitor;
import ch.epfl.labos.iu.orm.queryll2.symbolic.TypedValueVisitorException;
import java.util.ArrayList;
import org.revenj.postgres.jinq.jpqlquery.BinaryExpression;
import org.revenj.postgres.jinq.jpqlquery.CaseWhenExpression;
import org.revenj.postgres.jinq.jpqlquery.ColumnExpressions;
import org.revenj.postgres.jinq.jpqlquery.Expression;
import org.revenj.postgres.jinq.transform.LambdaAnalysis;
import org.revenj.postgres.jinq.transform.RevenjQueryTransformConfiguration;
import org.revenj.postgres.jinq.transform.SymbExPassDown;
import org.revenj.postgres.jinq.transform.SymbExToColumns;

public abstract class RevenjQueryTransform {
    RevenjQueryTransformConfiguration config = new RevenjQueryTransformConfiguration();

    RevenjQueryTransform(RevenjQueryTransformConfiguration config) {
        this.config = config;
    }

    protected <U> ColumnExpressions<U> makeSelectExpression(SymbExToColumns translator, LambdaAnalysis lambda) throws TypedValueVisitorException {
        int n;
        if (lambda.symbolicAnalysis.paths.size() == 1) {
            SymbExPassDown passdown = SymbExPassDown.with(null, false);
            return this.simplifyAndTranslateMainPathToColumns(lambda, translator, passdown);
        }
        int numPaths = lambda.symbolicAnalysis.paths.size();
        ArrayList<ColumnExpressions<U>> returnExprs = new ArrayList<ColumnExpressions<U>>(numPaths);
        ArrayList<Expression> pathExprs = new ArrayList<Expression>(numPaths);
        for (n = 0; n < numPaths; ++n) {
            SymbExPassDown passdown = SymbExPassDown.with(null, false);
            returnExprs.add(this.simplifyAndTranslatePathToColumns(lambda, n, translator, passdown));
            pathExprs.add(this.pathConditionsToExpr(translator, (PathAnalysis)lambda.symbolicAnalysis.paths.get(n)));
        }
        for (n = 1; n < numPaths; ++n) {
            if (((ColumnExpressions)returnExprs.get(n)).getNumColumns() == ((ColumnExpressions)returnExprs.get(0)).getNumColumns()) continue;
            throw new TypedValueVisitorException("Different paths returned different numbers of columns");
        }
        ColumnExpressions toReturn = new ColumnExpressions(((ColumnExpressions)returnExprs.get((int)0)).reader);
        for (int col = 0; col < ((ColumnExpressions)returnExprs.get(0)).getNumColumns(); ++col) {
            boolean allSame = true;
            for (int n2 = 1; n2 < numPaths; ++n2) {
                if (((ColumnExpressions)returnExprs.get((int)n2)).columns.get(col).equals(((ColumnExpressions)returnExprs.get((int)0)).columns.get(col))) continue;
                allSame = false;
                break;
            }
            if (allSame) {
                toReturn.columns.add(((ColumnExpressions)returnExprs.get((int)0)).columns.get(col));
                continue;
            }
            ArrayList<CaseWhenExpression.ConditionResult> cases = new ArrayList<CaseWhenExpression.ConditionResult>();
            for (int n3 = 0; n3 < numPaths; ++n3) {
                CaseWhenExpression.ConditionResult c = new CaseWhenExpression.ConditionResult();
                c.condition = (Expression)pathExprs.get(n3);
                c.result = ((ColumnExpressions)returnExprs.get((int)n3)).columns.get(col);
                cases.add(c);
            }
            toReturn.columns.add(new CaseWhenExpression(cases));
        }
        return toReturn;
    }

    protected <U> ColumnExpressions<U> simplifyAndTranslateMainPathToColumns(LambdaAnalysis lambda, SymbExToColumns translator, SymbExPassDown passdown) throws TypedValueVisitorException {
        return this.simplifyAndTranslatePathToColumns(lambda, 0, translator, passdown);
    }

    protected <U> ColumnExpressions<U> simplifyAndTranslatePathToColumns(LambdaAnalysis lambda, int pathIdx, SymbExToColumns translator, SymbExPassDown passdown) throws TypedValueVisitorException {
        return (ColumnExpressions)PathAnalysisSimplifier.simplify((TypedValue)((PathAnalysis)lambda.symbolicAnalysis.paths.get(pathIdx)).getReturnValue(), this.config.getComparisonMethods()).visit((TypedValueVisitor)translator, (Object)passdown);
    }

    protected Expression pathConditionsToExpr(SymbExToColumns translator, PathAnalysis path) throws TypedValueVisitorException {
        Expression conditionExpr = null;
        for (TypedValue cmp : path.getConditions()) {
            SymbExPassDown passdown;
            ColumnExpressions col = (ColumnExpressions)cmp.visit((TypedValueVisitor)translator, (Object)(passdown = SymbExPassDown.with(null, true)));
            if (!col.isSingleColumn()) {
                throw new TypedValueVisitorException("Expecting a single column result for path condition");
            }
            Expression expr = col.getOnlyColumn();
            if (conditionExpr != null) {
                conditionExpr = new BinaryExpression(conditionExpr, "AND", expr);
                continue;
            }
            conditionExpr = expr;
        }
        return conditionExpr;
    }

    public abstract String getTransformationTypeCachingTag();
}

