/*
 * Decompiled with CFR 0.152.
 */
package org.revenj.postgres.jinq.transform;

import ch.epfl.labos.iu.orm.queryll2.path.Annotations;
import ch.epfl.labos.iu.orm.queryll2.path.TransformationClassAnalyzer;
import ch.epfl.labos.iu.orm.queryll2.symbolic.ConstantValue;
import ch.epfl.labos.iu.orm.queryll2.symbolic.LambdaFactory;
import ch.epfl.labos.iu.orm.queryll2.symbolic.MethodCallValue;
import ch.epfl.labos.iu.orm.queryll2.symbolic.MethodSignature;
import ch.epfl.labos.iu.orm.queryll2.symbolic.TypedValue;
import ch.epfl.labos.iu.orm.queryll2.symbolic.TypedValueVisitor;
import ch.epfl.labos.iu.orm.queryll2.symbolic.TypedValueVisitorException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jinq.rebased.org.objectweb.asm.Type;
import org.revenj.postgres.jinq.jpqlquery.BinaryExpression;
import org.revenj.postgres.jinq.jpqlquery.ColumnExpressions;
import org.revenj.postgres.jinq.jpqlquery.ConstantExpression;
import org.revenj.postgres.jinq.jpqlquery.Expression;
import org.revenj.postgres.jinq.jpqlquery.FunctionExpression;
import org.revenj.postgres.jinq.jpqlquery.JinqPostgresQuery;
import org.revenj.postgres.jinq.jpqlquery.ParameterAsQuery;
import org.revenj.postgres.jinq.jpqlquery.ReadFieldExpression;
import org.revenj.postgres.jinq.jpqlquery.RowReader;
import org.revenj.postgres.jinq.jpqlquery.SelectFromWhere;
import org.revenj.postgres.jinq.jpqlquery.SelectOnly;
import org.revenj.postgres.jinq.jpqlquery.SimpleRowReader;
import org.revenj.postgres.jinq.jpqlquery.SubqueryExpression;
import org.revenj.postgres.jinq.jpqlquery.TupleRowReader;
import org.revenj.postgres.jinq.jpqlquery.UnaryExpression;
import org.revenj.postgres.jinq.transform.AggregateTransform;
import org.revenj.postgres.jinq.transform.LambdaAnalysis;
import org.revenj.postgres.jinq.transform.MetamodelUtil;
import org.revenj.postgres.jinq.transform.MethodChecker;
import org.revenj.postgres.jinq.transform.MethodHandlerStatic;
import org.revenj.postgres.jinq.transform.MethodHandlerVirtual;
import org.revenj.postgres.jinq.transform.QueryTransformException;
import org.revenj.postgres.jinq.transform.RevenjQueryTransformConfiguration;
import org.revenj.postgres.jinq.transform.SymbExArgumentHandler;
import org.revenj.postgres.jinq.transform.SymbExPassDown;
import org.revenj.postgres.jinq.transform.SymbExToSubQuery;

public class SymbExToColumns
extends TypedValueVisitor<SymbExPassDown, ColumnExpressions<?>, TypedValueVisitorException> {
    final SymbExArgumentHandler argHandler;
    final RevenjQueryTransformConfiguration config;
    static Map<Type, Integer> numericPromotionPriority = new HashMap<Type, Integer>();

    SymbExToColumns(RevenjQueryTransformConfiguration config, SymbExArgumentHandler argumentHandler) {
        this.config = config;
        this.argHandler = argumentHandler;
    }

    public ColumnExpressions<?> defaultValue(TypedValue val, SymbExPassDown in) throws TypedValueVisitorException {
        throw new TypedValueVisitorException("Unhandled symbolic execution operation: " + val);
    }

    public ColumnExpressions<?> argValue(TypedValue.ArgValue val, SymbExPassDown in) throws TypedValueVisitorException {
        int index = val.getIndex();
        return this.argHandler.handleArg(index, val.getType());
    }

    public ColumnExpressions<?> booleanConstantValue(ConstantValue.BooleanConstant val, SymbExPassDown in) throws TypedValueVisitorException {
        return ColumnExpressions.singleColumn(SimpleRowReader.READER, new ConstantExpression(val.val ? "true" : "false"));
    }

    public ColumnExpressions<?> integerConstantValue(ConstantValue.IntegerConstant val, SymbExPassDown in) throws TypedValueVisitorException {
        return ColumnExpressions.singleColumn(SimpleRowReader.READER, new ConstantExpression(Integer.toString(val.val)));
    }

    public ColumnExpressions<?> longConstantValue(ConstantValue.LongConstant val, SymbExPassDown in) throws TypedValueVisitorException {
        return ColumnExpressions.singleColumn(SimpleRowReader.READER, new ConstantExpression(Long.toString(val.val)));
    }

    public ColumnExpressions<?> doubleConstantValue(ConstantValue.DoubleConstant val, SymbExPassDown in) throws TypedValueVisitorException {
        return ColumnExpressions.singleColumn(SimpleRowReader.READER, new ConstantExpression(Double.toString(val.val)));
    }

    public ColumnExpressions<?> stringConstantValue(ConstantValue.StringConstant val, SymbExPassDown in) throws TypedValueVisitorException {
        return ColumnExpressions.singleColumn(SimpleRowReader.READER, new ConstantExpression("'" + val.val.replaceAll("'", "''") + "'"));
    }

    public ColumnExpressions<?> nullConstantValue(ConstantValue.NullConstant val, SymbExPassDown in) throws TypedValueVisitorException {
        throw new TypedValueVisitorException("Unexpected NULL value");
    }

    public ColumnExpressions<?> unaryMathOpValue(TypedValue.UnaryMathOpValue val, SymbExPassDown in) throws TypedValueVisitorException {
        SymbExPassDown passdown = SymbExPassDown.with((TypedValue)val, false);
        ColumnExpressions left = (ColumnExpressions)val.operand.visit((TypedValueVisitor)this, (Object)passdown);
        return ColumnExpressions.singleColumn(left.reader, UnaryExpression.prefix(val.op.getOpString(), left.getOnlyColumn()));
    }

    public ColumnExpressions<?> notOpValue(TypedValue.NotValue val, SymbExPassDown in) throws TypedValueVisitorException {
        SymbExPassDown passdown = SymbExPassDown.with((TypedValue)val, true);
        ColumnExpressions left = (ColumnExpressions)val.operand.visit((TypedValueVisitor)this, (Object)passdown);
        return ColumnExpressions.singleColumn(left.reader, UnaryExpression.prefix("NOT", left.getOnlyColumn()));
    }

    public ColumnExpressions<?> getStaticFieldValue(TypedValue.GetStaticFieldValue val, SymbExPassDown in) throws TypedValueVisitorException {
        String dbEnum = this.config.metamodel.getEnumName(val.owner);
        if (dbEnum != null) {
            return ColumnExpressions.singleColumn(SimpleRowReader.READER, new ConstantExpression("'" + val.name + "'::" + dbEnum));
        }
        if ("java/lang/Boolean".equals(val.owner) && ("TRUE".equals(val.name) || "FALSE".equals(val.name))) {
            return ColumnExpressions.singleColumn(SimpleRowReader.READER, new ConstantExpression("TRUE".equals(val.name) ? "TRUE" : "FALSE"));
        }
        return this.defaultValue((TypedValue)val, in);
    }

    public ColumnExpressions<?> castValue(TypedValue.CastValue val, SymbExPassDown in) throws TypedValueVisitorException {
        if (val.isPrimitive()) {
            throw new TypedValueVisitorException("Casts of primitive values are not support in JPQL");
        }
        return (ColumnExpressions)val.operand.visit((TypedValueVisitor)this, (Object)SymbExPassDown.with((TypedValue)val, in.isExpectingConditional));
    }

    public boolean isWideningCast(TypedValue val) {
        MethodCallValue.StaticMethodCallValue methodCall;
        MethodSignature sig;
        if (val instanceof TypedValue.CastValue) {
            TypedValue.CastValue castedVal = (TypedValue.CastValue)val;
            Type toType = castedVal.getType();
            Type fromType = castedVal.operand.getType();
            if (!numericPromotionPriority.containsKey(fromType)) {
                return false;
            }
            if (!numericPromotionPriority.containsKey(toType)) {
                return false;
            }
            if (numericPromotionPriority.get(toType) > numericPromotionPriority.get(fromType)) {
                return true;
            }
        } else if (val instanceof MethodCallValue.VirtualMethodCallValue) {
            MethodCallValue.VirtualMethodCallValue methodCall2 = (MethodCallValue.VirtualMethodCallValue)val;
            MethodSignature sig2 = methodCall2.getSignature();
            if (sig2.equals((Object)TransformationClassAnalyzer.newBigDecimalLong) || sig2.equals((Object)TransformationClassAnalyzer.newBigDecimalInt) || sig2.equals((Object)TransformationClassAnalyzer.newBigDecimalBigInteger)) {
                return true;
            }
            if (sig2.equals((Object)TransformationClassAnalyzer.bigDecimalDoubleValue) || sig2.equals((Object)TransformationClassAnalyzer.bigIntegerDoubleValue)) {
                return true;
            }
        } else if (val instanceof MethodCallValue.StaticMethodCallValue && (sig = (methodCall = (MethodCallValue.StaticMethodCallValue)val).getSignature()).equals((Object)TransformationClassAnalyzer.bigIntegerValueOfLong)) {
            return true;
        }
        return false;
    }

    public TypedValue skipWideningCast(TypedValue val) throws TypedValueVisitorException {
        MethodCallValue.StaticMethodCallValue methodCall;
        MethodSignature sig;
        if (!this.isWideningCast(val)) {
            return val;
        }
        if (val instanceof TypedValue.CastValue) {
            TypedValue.CastValue castedVal = (TypedValue.CastValue)val;
            return this.skipWideningCast(castedVal.operand);
        }
        if (val instanceof MethodCallValue.VirtualMethodCallValue) {
            MethodCallValue.VirtualMethodCallValue methodCall2 = (MethodCallValue.VirtualMethodCallValue)val;
            MethodSignature sig2 = methodCall2.getSignature();
            if (sig2.equals((Object)TransformationClassAnalyzer.newBigDecimalLong) || sig2.equals((Object)TransformationClassAnalyzer.newBigDecimalInt) || sig2.equals((Object)TransformationClassAnalyzer.newBigDecimalBigInteger)) {
                return this.skipWideningCast((TypedValue)methodCall2.args.get(0));
            }
            if (sig2.equals((Object)TransformationClassAnalyzer.bigDecimalDoubleValue) || sig2.equals((Object)TransformationClassAnalyzer.bigIntegerDoubleValue)) {
                return this.skipWideningCast(methodCall2.base);
            }
        } else if (val instanceof MethodCallValue.StaticMethodCallValue && (sig = (methodCall = (MethodCallValue.StaticMethodCallValue)val).getSignature()).equals((Object)TransformationClassAnalyzer.bigIntegerValueOfLong)) {
            return this.skipWideningCast((TypedValue)methodCall.args.get(0));
        }
        throw new IllegalArgumentException("Cannot skip an unknown widening cast type");
    }

    private <U> ColumnExpressions<U> binaryOpWithNull(String opString, TypedValue leftVal, TypedValue rightVal, SymbExPassDown passdown) throws TypedValueVisitorException {
        if (!"=".equals(opString) && !"<>".equals(opString)) {
            throw new TypedValueVisitorException("Unhandled operation involving NULL");
        }
        if (leftVal instanceof ConstantValue.NullConstant && rightVal instanceof ConstantValue.NullConstant) {
            throw new TypedValueVisitorException("Cannot handle comparisons involving two NULLs");
        }
        TypedValue operandVal = leftVal instanceof ConstantValue.NullConstant ? rightVal : leftVal;
        ColumnExpressions operand = (ColumnExpressions)operandVal.visit((TypedValueVisitor)this, (Object)passdown);
        if ("=".equals(opString)) {
            return ColumnExpressions.singleColumn(SimpleRowReader.READER, UnaryExpression.postfix("IS NULL", operand.getOnlyColumn()));
        }
        return ColumnExpressions.singleColumn(SimpleRowReader.READER, UnaryExpression.postfix("IS NOT NULL", operand.getOnlyColumn()));
    }

    private <U> ColumnExpressions<U> binaryOpWithNumericPromotion(String opString, TypedValue leftVal, TypedValue rightVal, SymbExPassDown passdown) throws TypedValueVisitorException {
        boolean isFinalTypeFromLeft = true;
        if (leftVal instanceof ConstantValue.NullConstant || rightVal instanceof ConstantValue.NullConstant) {
            return this.binaryOpWithNull(opString, leftVal, rightVal, passdown);
        }
        assert (leftVal.getType().equals((Object)rightVal.getType()) || leftVal.getType().getInternalName().equals("java/lang/Object") && this.config.isObjectEqualsSafe || rightVal.getType().getInternalName().equals("java/lang/Object") && this.config.isObjectEqualsSafe);
        if (this.isWideningCast(leftVal)) {
            if (!this.isWideningCast(rightVal)) {
                leftVal = this.skipWideningCast(leftVal);
                isFinalTypeFromLeft = false;
            }
        } else if (this.isWideningCast(rightVal)) {
            rightVal = this.skipWideningCast(rightVal);
        }
        ColumnExpressions left = (ColumnExpressions)leftVal.visit((TypedValueVisitor)this, (Object)passdown);
        ColumnExpressions right = (ColumnExpressions)rightVal.visit((TypedValueVisitor)this, (Object)passdown);
        return ColumnExpressions.singleColumn(isFinalTypeFromLeft ? left.reader : right.reader, new BinaryExpression(left.getOnlyColumn(), opString, right.getOnlyColumn()));
    }

    public ColumnExpressions<?> mathOpValue(TypedValue.MathOpValue val, SymbExPassDown in) throws TypedValueVisitorException {
        if (val.op == TypedValue.MathOpValue.Op.cmp) {
            throw new TypedValueVisitorException("cmp operator was not converted to a boolean operator");
        }
        if (val.op == TypedValue.MathOpValue.Op.mod) {
            if (val.left.getType().equals((Object)Type.INT_TYPE) || val.right.getType().equals((Object)Type.INT_TYPE)) {
                SymbExPassDown passdown = SymbExPassDown.with((TypedValue)val, false);
                ColumnExpressions left = (ColumnExpressions)val.left.visit((TypedValueVisitor)this, (Object)passdown);
                ColumnExpressions right = (ColumnExpressions)val.right.visit((TypedValueVisitor)this, (Object)passdown);
                return ColumnExpressions.singleColumn(left.reader, new BinaryExpression(left.getOnlyColumn(), "%", right.getOnlyColumn()));
            }
            throw new TypedValueVisitorException("mod operator cannot be used for the given types.");
        }
        SymbExPassDown passdown = SymbExPassDown.with((TypedValue)val, false);
        return this.binaryOpWithNumericPromotion(val.sqlOpString(), val.left, val.right, passdown);
    }

    public ColumnExpressions<?> comparisonOpValue(TypedValue.ComparisonValue val, SymbExPassDown in) throws TypedValueVisitorException {
        SymbExPassDown passdown = SymbExPassDown.with((TypedValue)val, false);
        return this.binaryOpWithNumericPromotion(val.sqlOpString(), val.left, val.right, passdown);
    }

    private boolean isAggregateMethod(MethodSignature sig) {
        return sig.equals((Object)MethodChecker.streamSumInt) || sig.equals((Object)MethodChecker.streamSumDouble) || sig.equals((Object)MethodChecker.streamSumLong) || sig.equals((Object)MethodChecker.streamSumBigInteger) || sig.equals((Object)MethodChecker.streamSumBigDecimal) || sig.equals((Object)MethodChecker.streamMax) || sig.equals((Object)MethodChecker.streamMin) || sig.equals((Object)MethodChecker.streamAvg) || sig.equals((Object)MethodChecker.streamCount);
    }

    public ColumnExpressions<?> virtualMethodCallValue(MethodCallValue.VirtualMethodCallValue val, SymbExPassDown in) throws TypedValueVisitorException {
        MethodSignature sig = val.getSignature();
        if (TransformationClassAnalyzer.newPair.equals((Object)sig) || TransformationClassAnalyzer.newTuple3.equals((Object)sig) || TransformationClassAnalyzer.newTuple4.equals((Object)sig) || TransformationClassAnalyzer.newTuple5.equals((Object)sig) || TransformationClassAnalyzer.newTuple6.equals((Object)sig) || TransformationClassAnalyzer.newTuple7.equals((Object)sig) || TransformationClassAnalyzer.newTuple8.equals((Object)sig)) {
            ColumnExpressions[] vals = new ColumnExpressions[val.args.size()];
            SymbExPassDown passdown = SymbExPassDown.with((TypedValue)val, in.isExpectingConditional);
            for (int n = 0; n < vals.length; ++n) {
                vals[n] = (ColumnExpressions)((TypedValue)val.args.get(n)).visit((TypedValueVisitor)this, (Object)passdown);
            }
            RowReader[] valReaders = new RowReader[vals.length];
            for (int n = 0; n < vals.length; ++n) {
                valReaders[n] = vals[n].reader;
            }
            ColumnExpressions toReturn = new ColumnExpressions(TupleRowReader.createReaderForTuple(sig.owner, valReaders));
            for (int n = 0; n < vals.length; ++n) {
                toReturn.columns.addAll(vals[n].columns);
            }
            return toReturn;
        }
        if (this.config.metamodel.isSingularAttributeFieldMethod(sig)) {
            String fieldName = this.config.metamodel.fieldMethodToFieldName(sig);
            SymbExPassDown passdown = SymbExPassDown.with((TypedValue)val, in.isExpectingConditional);
            ColumnExpressions base = (ColumnExpressions)val.base.visit((TypedValueVisitor)this, (Object)passdown);
            if (in.isExpectingConditional && (sig.getReturnType().equals((Object)Type.BOOLEAN_TYPE) || sig.getReturnType().equals((Object)Type.getObjectType((String)"java/lang/Boolean")))) {
                return ColumnExpressions.singleColumn(SimpleRowReader.READER, new BinaryExpression(new ReadFieldExpression(base.getOnlyColumn(), fieldName), "=", new ConstantExpression("TRUE")));
            }
            return ColumnExpressions.singleColumn(SimpleRowReader.READER, new ReadFieldExpression(base.getOnlyColumn(), fieldName));
        }
        if (MetamodelUtil.TUPLE_ACCESSORS.containsKey(sig)) {
            int idx = MetamodelUtil.TUPLE_ACCESSORS.get(sig) - 1;
            SymbExPassDown passdown = SymbExPassDown.with((TypedValue)val, in.isExpectingConditional);
            ColumnExpressions base = (ColumnExpressions)val.base.visit((TypedValueVisitor)this, (Object)passdown);
            RowReader<?> subreader = ((TupleRowReader)base.reader).getReaderForIndex(idx);
            ColumnExpressions toReturn = new ColumnExpressions(subreader);
            int baseOffset = ((TupleRowReader)base.reader).getColumnForIndex(idx);
            for (int n = 0; n < subreader.getNumColumns(); ++n) {
                toReturn.columns.add(base.columns.get(n + baseOffset));
            }
            return toReturn;
        }
        if (sig.equals((Object)TransformationClassAnalyzer.integerIntValue) || sig.equals((Object)TransformationClassAnalyzer.longLongValue) || sig.equals((Object)TransformationClassAnalyzer.doubleDoubleValue) || sig.equals((Object)TransformationClassAnalyzer.booleanBooleanValue)) {
            SymbExPassDown passdown = SymbExPassDown.with((TypedValue)val, in.isExpectingConditional);
            ColumnExpressions base = (ColumnExpressions)val.base.visit((TypedValueVisitor)this, (Object)passdown);
            return base;
        }
        if (sig.equals((Object)TransformationClassAnalyzer.newBigDecimalLong) || sig.equals((Object)TransformationClassAnalyzer.newBigDecimalDouble) || sig.equals((Object)TransformationClassAnalyzer.newBigDecimalInt) || sig.equals((Object)TransformationClassAnalyzer.newBigDecimalBigInteger)) {
            throw new TypedValueVisitorException("New BigDecimals can only be created in the context of numeric promotion");
        }
        if (this.isAggregateMethod(sig)) {
            SymbExPassDown passdown = SymbExPassDown.with((TypedValue)val, false);
            SymbExToSubQuery translator = this.config.newSymbExToSubQuery(this.argHandler, true);
            JinqPostgresQuery subQuery = (JinqPostgresQuery)val.base.visit((TypedValueVisitor)translator, (Object)passdown);
            LambdaAnalysis lambda = null;
            if (val.args.size() > 0) {
                if (!(val.args.get(0) instanceof LambdaFactory)) {
                    throw new TypedValueVisitorException("Expecting a lambda factory for aggregate method");
                }
                LambdaFactory lambdaFactory = (LambdaFactory)val.args.get(0);
                try {
                    lambda = LambdaAnalysis.analyzeMethod(this.config.metamodel, this.config.alternateClassLoader, this.config.isObjectEqualsSafe, this.config.isCollectionContainsSafe, lambdaFactory.getLambdaMethod(), lambdaFactory.getCapturedArgs(), true);
                }
                catch (Exception e) {
                    throw new TypedValueVisitorException("Could not analyze the lambda code", (Throwable)e);
                }
            }
            try {
                AggregateTransform transform;
                if (sig.equals((Object)MethodChecker.streamSumInt) || sig.equals((Object)MethodChecker.streamSumLong) || sig.equals((Object)MethodChecker.streamSumDouble) || sig.equals((Object)MethodChecker.streamSumBigDecimal) || sig.equals((Object)MethodChecker.streamSumBigInteger)) {
                    transform = new AggregateTransform(this.config, AggregateTransform.AggregateType.SUM);
                } else if (sig.equals((Object)MethodChecker.streamMax)) {
                    transform = new AggregateTransform(this.config, AggregateTransform.AggregateType.MAX);
                } else if (sig.equals((Object)MethodChecker.streamMin)) {
                    transform = new AggregateTransform(this.config, AggregateTransform.AggregateType.MIN);
                } else if (sig.equals((Object)MethodChecker.streamAvg)) {
                    transform = new AggregateTransform(this.config, AggregateTransform.AggregateType.AVG);
                } else if (sig.equals((Object)MethodChecker.streamCount)) {
                    transform = new AggregateTransform(this.config, AggregateTransform.AggregateType.COUNT);
                } else {
                    throw new TypedValueVisitorException("Unhandled aggregate operation");
                }
                JinqPostgresQuery aggregatedQuery = transform.apply(subQuery, lambda, this.argHandler);
                if (aggregatedQuery.getClass() == SelectOnly.class) {
                    SelectOnly select = (SelectOnly)aggregatedQuery;
                    return select.cols;
                }
                if (aggregatedQuery.isValidSubquery() && aggregatedQuery instanceof SelectFromWhere) {
                    SelectFromWhere sfw = (SelectFromWhere)aggregatedQuery;
                    ColumnExpressions toReturn = new ColumnExpressions(sfw.cols.reader);
                    for (Expression col : sfw.cols.columns) {
                        SelectOnly oneColQuery = sfw.shallowCopy();
                        ((SelectFromWhere)oneColQuery).cols = ColumnExpressions.singleColumn(SimpleRowReader.READER, col);
                        toReturn.columns.add(SubqueryExpression.from(oneColQuery));
                    }
                    return toReturn;
                }
                throw new TypedValueVisitorException("Unknown subquery type");
            }
            catch (QueryTransformException e) {
                throw new TypedValueVisitorException("Could not derive an aggregate function for a lambda", (Throwable)e);
            }
        }
        if (sig.equals((Object)MethodChecker.streamGetOnlyValue)) {
            SymbExPassDown passdown = SymbExPassDown.with((TypedValue)val, false);
            SymbExToSubQuery translator = this.config.newSymbExToSubQuery(this.argHandler, true);
            JinqPostgresQuery subQuery = (JinqPostgresQuery)val.base.visit((TypedValueVisitor)translator, (Object)passdown);
            if (subQuery.isValidSubquery() && subQuery instanceof SelectFromWhere) {
                SelectFromWhere sfw = (SelectFromWhere)subQuery;
                ColumnExpressions toReturn = new ColumnExpressions(sfw.cols.reader);
                for (Expression col : sfw.cols.columns) {
                    SelectOnly oneColQuery = sfw.shallowCopy();
                    ((SelectFromWhere)oneColQuery).cols = ColumnExpressions.singleColumn(SimpleRowReader.READER, col);
                    toReturn.columns.add(SubqueryExpression.from(oneColQuery));
                }
                return toReturn;
            }
            throw new TypedValueVisitorException("Cannot apply getOnlyValue() to the given subquery");
        }
        MethodHandlerVirtual handler = MethodChecker.jpqlFunctionMethods.get(sig);
        if (handler != null) {
            return handler.handle(val, in, this);
        }
        if (sig.equals((Object)TransformationClassAnalyzer.stringBuilderToString)) {
            ArrayList<Object> concatenatedStrings;
            block43: {
                concatenatedStrings = new ArrayList<Object>();
                MethodCallValue.VirtualMethodCallValue baseVal = val;
                while (true) {
                    SymbExPassDown passdown;
                    if (!(baseVal.base instanceof MethodCallValue.VirtualMethodCallValue)) {
                        throw new TypedValueVisitorException("Unexpected use of StringBuilder");
                    }
                    baseVal = (MethodCallValue.VirtualMethodCallValue)baseVal.base;
                    if (baseVal.getSignature().equals((Object)TransformationClassAnalyzer.newStringBuilderString)) {
                        passdown = SymbExPassDown.with((TypedValue)val, false);
                        concatenatedStrings.add(((TypedValue)baseVal.args.get(0)).visit((TypedValueVisitor)this, (Object)passdown));
                        break block43;
                    }
                    if (baseVal.getSignature().equals((Object)TransformationClassAnalyzer.newStringBuilder)) break block43;
                    if (!baseVal.getSignature().equals((Object)TransformationClassAnalyzer.stringBuilderAppendString)) break;
                    passdown = SymbExPassDown.with((TypedValue)val, false);
                    concatenatedStrings.add(((TypedValue)baseVal.args.get(0)).visit((TypedValueVisitor)this, (Object)passdown));
                }
                throw new TypedValueVisitorException("Unexpected use of StringBuilder");
            }
            if (concatenatedStrings.size() == 1) {
                return (ColumnExpressions)concatenatedStrings.get(0);
            }
            Expression head = ((ColumnExpressions)concatenatedStrings.get(concatenatedStrings.size() - 1)).getOnlyColumn();
            for (int n = concatenatedStrings.size() - 2; n >= 0; --n) {
                head = FunctionExpression.twoParam("CONCAT", head, ((ColumnExpressions)concatenatedStrings.get(n)).getOnlyColumn());
            }
            return ColumnExpressions.singleColumn(SimpleRowReader.READER, head);
        }
        try {
            Method reflectedMethod = Annotations.asmMethodSignatureToReflectionMethod((MethodSignature)sig);
            if ("contains".equals(sig.name) && "(Ljava/lang/Object;)Z".equals(sig.desc) && Collection.class.isAssignableFrom(reflectedMethod.getDeclaringClass())) {
                TypedValue listVal = val.base;
                TypedValue itemVal = (TypedValue)val.args.get(0);
                return this.handleIsIn((TypedValue)val, listVal, itemVal, false);
            }
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            // empty catch block
        }
        return (ColumnExpressions)super.virtualMethodCallValue(val, (Object)in);
    }

    public ColumnExpressions<?> staticMethodCallValue(MethodCallValue.StaticMethodCallValue val, SymbExPassDown in) throws TypedValueVisitorException {
        MethodSignature sig = val.getSignature();
        if (sig.equals((Object)TransformationClassAnalyzer.integerValueOf) || sig.equals((Object)TransformationClassAnalyzer.longValueOf) || sig.equals((Object)TransformationClassAnalyzer.doubleValueOf) || sig.equals((Object)TransformationClassAnalyzer.booleanValueOf)) {
            SymbExPassDown passdown = SymbExPassDown.with((TypedValue)val, in.isExpectingConditional);
            ColumnExpressions base = (ColumnExpressions)((TypedValue)val.args.get(0)).visit((TypedValueVisitor)this, (Object)passdown);
            return base;
        }
        if (sig.equals((Object)TransformationClassAnalyzer.bigIntegerValueOfLong)) {
            throw new TypedValueVisitorException("New BigIntegers can only be created in the context of numeric promotion");
        }
        MethodHandlerStatic handler = MethodChecker.jpqlFunctionStaticMethods.get(sig);
        if (handler != null) {
            return handler.handle(val, in, this);
        }
        return (ColumnExpressions)super.staticMethodCallValue(val, (Object)in);
    }

    protected ColumnExpressions<?> handleIsIn(TypedValue parent, TypedValue listVal, TypedValue itemVal, boolean isExpectingStream) throws TypedValueVisitorException {
        SymbExPassDown passdown = SymbExPassDown.with(parent, false);
        ColumnExpressions item = (ColumnExpressions)itemVal.visit((TypedValueVisitor)this, (Object)passdown);
        SymbExToSubQuery translator = this.config.newSymbExToSubQuery(this.argHandler, isExpectingStream);
        JinqPostgresQuery subQuery = (JinqPostgresQuery)listVal.visit((TypedValueVisitor)translator, (Object)passdown);
        if (subQuery.isValidSubquery() && subQuery instanceof SelectFromWhere) {
            SelectFromWhere sfw = (SelectFromWhere)subQuery;
            return ColumnExpressions.singleColumn(SimpleRowReader.READER, new BinaryExpression("", item.getOnlyColumn(), "= ANY(", SubqueryExpression.from(sfw), ")"));
        }
        if (subQuery.isValidSubquery() && subQuery instanceof ParameterAsQuery) {
            ParameterAsQuery paramQuery = (ParameterAsQuery)subQuery;
            return ColumnExpressions.singleColumn(SimpleRowReader.READER, new BinaryExpression("", item.getOnlyColumn(), "= ANY(", paramQuery.cols.getOnlyColumn(), ")"));
        }
        throw new TypedValueVisitorException("Trying to create a query using IN but with an unhandled subquery type");
    }

    static {
        int n = 0;
        numericPromotionPriority.put(Type.INT_TYPE, n);
        numericPromotionPriority.put(Type.getObjectType((String)"java/lang/Integer"), n);
        numericPromotionPriority.put(Type.LONG_TYPE, ++n);
        numericPromotionPriority.put(Type.getObjectType((String)"java/lang/Long"), n);
        numericPromotionPriority.put(Type.getObjectType((String)"java/math/BigInteger"), ++n);
        numericPromotionPriority.put(Type.getObjectType((String)"java/math/BigDecimal"), ++n);
        numericPromotionPriority.put(Type.DOUBLE_TYPE, ++n);
        numericPromotionPriority.put(Type.getObjectType((String)"java/lang/Double"), n);
        ++n;
    }
}

