/*
 * Decompiled with CFR 0.152.
 */
package org.revenj.patterns;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.revenj.patterns.ServiceLocator;

public abstract class Generic<T> {
    public final Type type;

    protected Generic() {
        Type superclass = this.getClass().getGenericSuperclass();
        if (superclass instanceof Class) {
            throw new RuntimeException("Missing type parameter.");
        }
        this.type = ((ParameterizedType)superclass).getActualTypeArguments()[0];
    }

    public T resolve(ServiceLocator locator) {
        try {
            return (T)locator.resolve(this.type);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }
}

