/*
 * Decompiled with CFR 0.152.
 */
package org.revenj.postgres.converters;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.revenj.postgres.PostgresBuffer;
import org.revenj.postgres.PostgresReader;
import org.revenj.postgres.converters.PostgresTuple;
import org.revenj.postgres.converters.StringConverter;
import org.revenj.postgres.converters.ValueTuple;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class XmlConverter {
    private static DocumentBuilder documentBuilder;

    private static String xmlToString(Element value) {
        Document document = value.getOwnerDocument();
        DOMImplementationLS domImplLS = (DOMImplementationLS)((Object)document.getImplementation());
        LSSerializer serializer = domImplLS.createLSSerializer();
        LSOutput lsOutput = domImplLS.createLSOutput();
        lsOutput.setEncoding("UTF-8");
        StringWriter writer = new StringWriter();
        lsOutput.setCharacterStream(writer);
        serializer.write(value, lsOutput);
        return writer.toString();
    }

    public static void serializeURI(PostgresBuffer sw, Element value) {
        if (value == null) {
            return;
        }
        sw.addToBuffer(XmlConverter.xmlToString(value));
    }

    public static void setParameter(PostgresBuffer sw, PreparedStatement ps, int index, Element value) throws SQLException {
        SQLXML xml = ps.getConnection().createSQLXML();
        xml.setString(XmlConverter.xmlToString(value));
        ps.setSQLXML(index, xml);
    }

    public static Element parse(PostgresReader reader, int context) throws IOException {
        String value = StringConverter.parse(reader, context, true);
        if (value == null) {
            return null;
        }
        return XmlConverter.stringToXml(value);
    }

    private static Element stringToXml(String value) throws IOException {
        if (value.length() == 0) {
            return null;
        }
        try {
            InputSource source = new InputSource(new StringReader(value));
            return documentBuilder.parse(source).getDocumentElement();
        }
        catch (SAXException ex) {
            throw new IOException(ex);
        }
    }

    public static List<Element> parseCollection(PostgresReader reader, int context, boolean allowNull) throws IOException {
        boolean escaped;
        int cur = reader.read();
        if (cur == 44 || cur == 41) {
            return null;
        }
        boolean bl = escaped = cur != 123;
        if (escaped) {
            reader.read(context);
        }
        if ((cur = reader.peek()) == 125) {
            if (escaped) {
                reader.read(context + 2);
            } else {
                reader.read(2);
            }
            return new ArrayList<Element>(0);
        }
        int innerContext = context << 1;
        ArrayList<Element> list = new ArrayList<Element>();
        do {
            if ((cur = reader.read()) == 34 || cur == 92) {
                list.add(XmlConverter.stringToXml(StringConverter.parseEscapedString(reader, innerContext, '}')));
                cur = reader.last();
                continue;
            }
            reader.initBuffer((char)cur);
            reader.fillUntil(',', '}');
            cur = reader.read();
            if (reader.bufferMatches("NULL")) {
                list.add(null);
                continue;
            }
            list.add(XmlConverter.stringToXml(reader.bufferToString()));
        } while (cur == 44);
        if (escaped) {
            reader.read(context + 1);
        } else {
            reader.read();
        }
        return list;
    }

    public static PostgresTuple toTuple(Element value) {
        if (value == null) {
            return null;
        }
        return ValueTuple.from(XmlConverter.xmlToString(value));
    }

    static {
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        try {
            documentBuilder = dbFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
    }
}

