/*
 * Decompiled with CFR 0.152.
 */
package org.revenj.postgres.jinq.transform;

import ch.epfl.labos.iu.orm.queryll2.symbolic.TypedValueVisitorException;
import org.revenj.postgres.jinq.jpqlquery.AggregateFunctionExpression;
import org.revenj.postgres.jinq.jpqlquery.ColumnExpressions;
import org.revenj.postgres.jinq.jpqlquery.ConstantExpression;
import org.revenj.postgres.jinq.jpqlquery.Expression;
import org.revenj.postgres.jinq.jpqlquery.JinqPostgresQuery;
import org.revenj.postgres.jinq.jpqlquery.SelectFromWhere;
import org.revenj.postgres.jinq.jpqlquery.SelectOnly;
import org.revenj.postgres.jinq.jpqlquery.SimpleRowReader;
import org.revenj.postgres.jinq.transform.LambdaAnalysis;
import org.revenj.postgres.jinq.transform.QueryTransformException;
import org.revenj.postgres.jinq.transform.RevenjOneLambdaQueryTransform;
import org.revenj.postgres.jinq.transform.RevenjQueryTransformConfiguration;
import org.revenj.postgres.jinq.transform.SelectFromWhereLambdaArgumentHandler;
import org.revenj.postgres.jinq.transform.SymbExArgumentHandler;
import org.revenj.postgres.jinq.transform.SymbExToColumns;

public class AggregateTransform
extends RevenjOneLambdaQueryTransform {
    private AggregateType type;

    public AggregateTransform(RevenjQueryTransformConfiguration config, AggregateType type) {
        super(config);
        this.type = type;
    }

    @Override
    public <U, V> JinqPostgresQuery<U> apply(JinqPostgresQuery<V> query, LambdaAnalysis lambda, SymbExArgumentHandler parentArgumentScope) throws QueryTransformException {
        try {
            if (query.isSelectFromWhere() || query instanceof SelectOnly) {
                SelectOnly select = (SelectOnly)query;
                Expression aggregatedExpr = null;
                if (this.type != AggregateType.COUNT) {
                    SelectFromWhereLambdaArgumentHandler argumentHandler;
                    SymbExToColumns translator;
                    if (select.isDistinct && (aggregatedExpr = this.makeSelectExpression(translator = this.config.newSymbExToColumns(argumentHandler = SelectFromWhereLambdaArgumentHandler.forPassthroughTest(lambda, this.config.metamodel, parentArgumentScope, false)), lambda).getOnlyColumn()) != SelectFromWhereLambdaArgumentHandler.passthroughColsForTesting.getOnlyColumn()) {
                        throw new TypedValueVisitorException("Applying an aggregation to a distinct stream, but modifying the stream after the distinct but before the aggregation");
                    }
                    if (select.isSelectFromWhere()) {
                        SelectFromWhere sfw = (SelectFromWhere)select;
                        argumentHandler = SelectFromWhereLambdaArgumentHandler.fromSelectFromWhere(sfw, lambda, this.config.metamodel, parentArgumentScope, false);
                    } else {
                        argumentHandler = SelectFromWhereLambdaArgumentHandler.fromSelectOnly(select, lambda, this.config.metamodel, parentArgumentScope, false);
                    }
                    translator = this.config.newSymbExToColumns(argumentHandler);
                    aggregatedExpr = this.makeSelectExpression(translator, lambda).getOnlyColumn();
                } else {
                    aggregatedExpr = select.cols.isSingleColumn() ? select.cols.getOnlyColumn() : new ConstantExpression("1");
                }
                JinqPostgresQuery toReturn = select.shallowCopy();
                ((SelectOnly)toReturn).isAggregated = true;
                ((SelectOnly)toReturn).cols = ColumnExpressions.singleColumn(SimpleRowReader.READER, new AggregateFunctionExpression(aggregatedExpr, this.type.name(), select.isDistinct));
                return toReturn;
            }
            throw new QueryTransformException("Existing query cannot be transformed further");
        }
        catch (TypedValueVisitorException e) {
            throw new QueryTransformException(e);
        }
    }

    @Override
    public String getTransformationTypeCachingTag() {
        return AggregateTransform.class.getName() + ":" + this.type.name();
    }

    public static enum AggregateType {
        SUM,
        AVG,
        MAX,
        MIN,
        COUNT;

    }
}

