/*
 * Decompiled with CFR 0.152.
 */
package org.revenj.postgres.jinq.transform;

import ch.epfl.labos.iu.orm.queryll2.path.PathAnalysis;
import ch.epfl.labos.iu.orm.queryll2.path.PathAnalysisSimplifier;
import ch.epfl.labos.iu.orm.queryll2.symbolic.TypedValue;
import ch.epfl.labos.iu.orm.queryll2.symbolic.TypedValueVisitor;
import ch.epfl.labos.iu.orm.queryll2.symbolic.TypedValueVisitorException;
import org.revenj.postgres.jinq.jpqlquery.ColumnExpressions;
import org.revenj.postgres.jinq.jpqlquery.Expression;
import org.revenj.postgres.jinq.jpqlquery.From;
import org.revenj.postgres.jinq.jpqlquery.FromAliasExpression;
import org.revenj.postgres.jinq.jpqlquery.JinqPostgresQuery;
import org.revenj.postgres.jinq.jpqlquery.RowReader;
import org.revenj.postgres.jinq.jpqlquery.SelectFromWhere;
import org.revenj.postgres.jinq.jpqlquery.SelectOnly;
import org.revenj.postgres.jinq.jpqlquery.TupleRowReader;
import org.revenj.postgres.jinq.transform.LambdaAnalysis;
import org.revenj.postgres.jinq.transform.OuterJoinTransform;
import org.revenj.postgres.jinq.transform.QueryTransformException;
import org.revenj.postgres.jinq.transform.RevenjOneLambdaQueryTransform;
import org.revenj.postgres.jinq.transform.RevenjQueryTransformConfiguration;
import org.revenj.postgres.jinq.transform.SelectFromWhereLambdaArgumentHandler;
import org.revenj.postgres.jinq.transform.SymbExArgumentHandler;
import org.revenj.postgres.jinq.transform.SymbExPassDown;
import org.revenj.postgres.jinq.transform.SymbExToSubQuery;

public class JoinTransform
extends RevenjOneLambdaQueryTransform {
    boolean withSource;
    boolean joinAsPairs;
    boolean isExpectingStream;
    boolean isJoinFetch;

    public JoinTransform(RevenjQueryTransformConfiguration config, boolean withSource, boolean joinAsPairs, boolean isExpectingStream, boolean isJoinFetch) {
        super(config);
        this.withSource = withSource;
        this.isExpectingStream = isExpectingStream;
        this.joinAsPairs = joinAsPairs;
        this.isJoinFetch = isJoinFetch;
    }

    public JoinTransform(RevenjQueryTransformConfiguration config) {
        this(config, false, true, true, false);
    }

    public JoinTransform setWithSource(boolean withSource) {
        this.withSource = withSource;
        return this;
    }

    public JoinTransform setIsExpectingStream(boolean isExpectingStream) {
        this.isExpectingStream = isExpectingStream;
        return this;
    }

    public JoinTransform setJoinAsPairs(boolean joinAsPairs) {
        this.joinAsPairs = joinAsPairs;
        return this;
    }

    public JoinTransform setIsJoinFetch(boolean isJoinFetch) {
        this.isJoinFetch = isJoinFetch;
        return this;
    }

    static boolean isSimpleFrom(JinqPostgresQuery<?> query) {
        if (!query.isSelectFromWhere()) {
            return false;
        }
        SelectFromWhere sfw = (SelectFromWhere)query;
        if (sfw.where != null) {
            return false;
        }
        if (sfw.froms.size() != 1) {
            return false;
        }
        if (!sfw.cols.isSingleColumn()) {
            return false;
        }
        Expression expr = sfw.cols.getOnlyColumn();
        if (!(expr instanceof FromAliasExpression)) {
            return false;
        }
        return ((FromAliasExpression)expr).from == sfw.froms.get(0);
    }

    @Override
    public <U, V> JinqPostgresQuery<U> apply(JinqPostgresQuery<V> query, LambdaAnalysis lambda, SymbExArgumentHandler parentArgumentScope) throws QueryTransformException {
        try {
            if (query.isSelectFromWhere()) {
                SelectFromWhere sfw = (SelectFromWhere)query;
                SymbExToSubQuery translator = this.config.newSymbExToSubQuery(SelectFromWhereLambdaArgumentHandler.fromSelectFromWhere(sfw, lambda, this.config.metamodel, parentArgumentScope, this.withSource), this.isExpectingStream);
                if (lambda.symbolicAnalysis.paths.size() > 1) {
                    throw new QueryTransformException("Can only handle a single path in a JOIN at the moment");
                }
                SymbExPassDown passdown = SymbExPassDown.with(null, false);
                JinqPostgresQuery returnExpr = (JinqPostgresQuery)PathAnalysisSimplifier.simplify((TypedValue)((PathAnalysis)lambda.symbolicAnalysis.paths.get(0)).getReturnValue(), this.config.getComparisonMethods()).visit((TypedValueVisitor)translator, (Object)passdown);
                if (JoinTransform.isSimpleFrom(returnExpr)) {
                    SelectFromWhere toMerge = (SelectFromWhere)returnExpr;
                    SelectOnly toReturn = sfw.shallowCopy();
                    if (this.isJoinFetch) {
                        From from = toMerge.froms.get(0);
                        if (!OuterJoinTransform.isLeftOuterJoinCompatible(toMerge)) {
                            throw new QueryTransformException("Left outer join must be applied to a navigational link");
                        }
                        From.FromNavigationalLinksJoinFetch joinFetchFrom = From.forNavigationalLinksJoinFetch((From.FromNavigationalLinks)from);
                        ((SelectFromWhere)toReturn).froms.add(joinFetchFrom);
                        OuterJoinTransform.rewriteFromAliases(toMerge, from, joinFetchFrom);
                    } else {
                        ((SelectFromWhere)toReturn).froms.add(toMerge.froms.get(0));
                    }
                    if (this.joinAsPairs) {
                        ((SelectFromWhere)toReturn).cols = new ColumnExpressions<U>(this.createPairReader(sfw.cols.reader, toMerge.cols.reader));
                        ((SelectFromWhere)toReturn).cols.columns.addAll(sfw.cols.columns);
                        ((SelectFromWhere)toReturn).cols.columns.addAll(toMerge.cols.columns);
                    } else {
                        ((SelectFromWhere)toReturn).cols = toMerge.cols;
                    }
                    return toReturn;
                }
            }
            throw new QueryTransformException("Existing query cannot be transformed further");
        }
        catch (TypedValueVisitorException e) {
            throw new QueryTransformException(e);
        }
    }

    protected <U> RowReader<U> createPairReader(RowReader<?> a, RowReader<?> b) {
        return TupleRowReader.createReaderForTuple(TupleRowReader.PAIR_CLASS, a, b);
    }

    @Override
    public String getTransformationTypeCachingTag() {
        return JoinTransform.class.getName();
    }
}

