/*
 * Decompiled with CFR 0.152.
 */
package org.revenj.postgres.jinq.transform;

import org.revenj.postgres.jinq.jpqlquery.JinqPostgresQuery;
import org.revenj.postgres.jinq.jpqlquery.SelectFromWhere;
import org.revenj.postgres.jinq.jpqlquery.SelectOnly;
import org.revenj.postgres.jinq.transform.QueryTransformException;
import org.revenj.postgres.jinq.transform.RevenjNoLambdaQueryTransform;
import org.revenj.postgres.jinq.transform.RevenjQueryTransformConfiguration;
import org.revenj.postgres.jinq.transform.SymbExArgumentHandler;

public class LimitSkipTransform
extends RevenjNoLambdaQueryTransform {
    boolean isLimit;
    long constraint;

    public LimitSkipTransform(RevenjQueryTransformConfiguration config, boolean isLimit, long n) {
        super(config);
        this.constraint = n;
        this.isLimit = isLimit;
    }

    @Override
    public <U, V> JinqPostgresQuery<U> apply(JinqPostgresQuery<V> query, SymbExArgumentHandler parentArgumentScope) throws QueryTransformException {
        if (query instanceof SelectFromWhere) {
            SelectFromWhere sfw = (SelectFromWhere)query;
            if (this.isLimit && sfw.limit >= 0L) {
                throw new IllegalArgumentException("Cannot limit a query more than once");
            }
            if (!this.isLimit && sfw.skip >= 0L) {
                throw new IllegalArgumentException("Cannot skip in a query more than once");
            }
            SelectOnly toReturn = sfw.shallowCopy();
            if (this.isLimit) {
                ((SelectFromWhere)toReturn).limit = this.constraint;
            } else {
                if (((SelectFromWhere)toReturn).limit >= 0L) {
                    ((SelectFromWhere)toReturn).limit -= this.constraint;
                }
                ((SelectFromWhere)toReturn).skip = this.constraint;
            }
            return toReturn;
        }
        throw new QueryTransformException("Existing query cannot be transformed further");
    }

    @Override
    public String getTransformationTypeCachingTag() {
        return LimitSkipTransform.class.getName() + ":" + this.isLimit + ":" + this.constraint;
    }
}

