/*
 * Decompiled with CFR 0.152.
 */
package org.revenj.serialization;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.util.Optional;
import org.revenj.Utils;
import org.revenj.patterns.Bytes;
import org.revenj.serialization.Serialization;

public interface WireSerialization {
    public Bytes serialize(Object var1, String var2);

    public void serialize(Object var1, OutputStream var2, String var3) throws IOException;

    public Object deserialize(Type var1, Bytes var2, String var3) throws IOException;

    public Object deserialize(Type var1, InputStream var2, String var3) throws IOException;

    default public <T> T deserialize(Bytes data, String accept, Class<T> manifest) throws IOException {
        return (T)this.deserialize(manifest, data, accept);
    }

    default public <T> T deserialize(Bytes data, String accept, Class<T> container, Type argument, Type ... arguments) throws IOException {
        return (T)this.deserialize((Type)Utils.makeGenericType(container, argument, arguments), data, accept);
    }

    default public <T> T deserialize(byte[] data, String accept, Class<T> manifest) throws IOException {
        return (T)this.deserialize(manifest, new Bytes(data, data.length), accept);
    }

    default public <T> T deserialize(byte[] data, String accept, Class<T> container, Type argument, Type ... arguments) throws IOException {
        return (T)this.deserialize((Type)Utils.makeGenericType(container, argument, arguments), new Bytes(data, data.length), accept);
    }

    default public <T> T deserialize(byte[] data, int length, String accept, Class<T> manifest) throws IOException {
        return (T)this.deserialize(manifest, new Bytes(data, length), accept);
    }

    default public <T> T deserialize(byte[] data, int length, String accept, Class<T> container, Type argument, Type ... arguments) throws IOException {
        return (T)this.deserialize((Type)Utils.makeGenericType(container, argument, arguments), new Bytes(data, length), accept);
    }

    default public <T> T deserialize(InputStream stream, String accept, Class<T> manifest) throws IOException {
        return (T)this.deserialize(manifest, stream, accept);
    }

    default public <T> T deserialize(InputStream stream, String accept, Class<T> container, Type argument, Type ... arguments) throws IOException {
        return (T)this.deserialize((Type)Utils.makeGenericType(container, argument, arguments), stream, accept);
    }

    public <TFormat> Optional<Serialization<TFormat>> find(Class<TFormat> var1);
}

