/*
 * Decompiled with CFR 0.152.
 */
package org.revenj.postgres;

import ch.epfl.labos.iu.orm.queryll2.symbolic.TypedValueVisitorException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.revenj.patterns.DataSource;
import org.revenj.patterns.OlapCubeQuery;
import org.revenj.patterns.ServiceLocator;
import org.revenj.patterns.Specification;
import org.revenj.postgres.jinq.RevenjQueryComposer;
import org.revenj.postgres.jinq.jpqlquery.ColumnExpressions;
import org.revenj.postgres.jinq.jpqlquery.From;
import org.revenj.postgres.jinq.jpqlquery.FromAliasExpression;
import org.revenj.postgres.jinq.jpqlquery.SelectFromWhere;
import org.revenj.postgres.jinq.jpqlquery.SimpleRowReader;
import org.revenj.postgres.jinq.transform.LambdaAnalysis;
import org.revenj.postgres.jinq.transform.LambdaInfo;
import org.revenj.postgres.jinq.transform.MetamodelUtil;
import org.revenj.postgres.jinq.transform.QueryTransformException;
import org.revenj.postgres.jinq.transform.RevenjQueryTransformConfiguration;
import org.revenj.postgres.jinq.transform.WhereTransform;

public abstract class PostgresOlapCubeQuery<TSource extends DataSource>
implements OlapCubeQuery<TSource> {
    protected final ServiceLocator locator;
    protected final Connection transactionConnection;
    protected final javax.sql.DataSource dataSource;
    private final MetamodelUtil metamodel;
    protected final Map<String, Function<String, String>> cubeDimensions = new LinkedHashMap<String, Function<String, String>>();
    protected final Map<String, Function<String, String>> cubeFacts = new LinkedHashMap<String, Function<String, String>>();

    protected abstract String getSource();

    protected PostgresOlapCubeQuery(ServiceLocator locator) {
        this.locator = locator;
        this.transactionConnection = locator.tryResolve(Connection.class).orElse(null);
        this.dataSource = this.transactionConnection != null ? null : locator.resolve(javax.sql.DataSource.class);
        this.metamodel = locator.resolve(MetamodelUtil.class);
    }

    @Override
    public Set<String> getDimensions() {
        return this.cubeDimensions.keySet();
    }

    @Override
    public Set<String> getFacts() {
        return this.cubeFacts.keySet();
    }

    private void validateInput(List<String> usedDimensions, List<String> usedFacts, Collection<String> customOrder) {
        if (usedDimensions.size() == 0 && usedFacts.size() == 0) {
            throw new IllegalArgumentException("Cube must have at least one dimension or fact.");
        }
        for (String d : usedDimensions) {
            if (this.cubeDimensions.containsKey(d)) continue;
            throw new IllegalArgumentException("Unknown dimension: " + d + ". Use getDimensions method for available dimensions");
        }
        for (String f : usedFacts) {
            if (this.cubeFacts.containsKey(f)) continue;
            throw new IllegalArgumentException("Unknown fact: " + f + ". Use getFacts method for available facts");
        }
        for (String o : customOrder) {
            if (usedDimensions.contains(o) || usedFacts.contains(o)) continue;
            throw new IllegalArgumentException("Invalid order: " + o + ". Order can be only field from used dimensions and facts.");
        }
    }

    protected String getLambdaAlias(Specification<TSource> specification) {
        return "it";
    }

    protected Connection getConnection() {
        if (this.transactionConnection != null) {
            return this.transactionConnection;
        }
        try {
            return this.dataSource.getConnection();
        }
        catch (SQLException e) {
            throw new RuntimeException("Unable to resolve connection for cube query. " + e.getMessage());
        }
    }

    protected void releaseConnection(Connection connection) throws SQLException {
        if (this.transactionConnection == null) {
            connection.close();
        }
    }

    private static RevenjQueryTransformConfiguration buildConfig(MetamodelUtil metamodel) {
        RevenjQueryTransformConfiguration config = new RevenjQueryTransformConfiguration();
        config.metamodel = metamodel;
        config.alternateClassLoader = null;
        config.isObjectEqualsSafe = true;
        config.isCollectionContainsSafe = true;
        return config;
    }

    private SelectFromWhere<TSource> applyTransformWithLambda(String name, LambdaInfo lambdaInfo) {
        if (lambdaInfo == null) {
            return null;
        }
        try {
            RevenjQueryTransformConfiguration config = PostgresOlapCubeQuery.buildConfig(this.metamodel);
            LambdaAnalysis lambdaAnalysis = lambdaInfo.fullyAnalyze(this.metamodel, null, true, true, true, true);
            if (lambdaAnalysis == null) {
                return null;
            }
            config.checkLambdaSideEffects(lambdaAnalysis);
            SelectFromWhere query = new SelectFromWhere();
            From.FromDataSource from = new From.FromDataSource();
            from.name = name;
            query.cols = ColumnExpressions.singleColumn(SimpleRowReader.READER, new FromAliasExpression(from));
            query.froms.add(from);
            WhereTransform where = new WhereTransform(config, false);
            return where.apply(lambdaAnalysis, null, query);
        }
        catch (TypedValueVisitorException | QueryTransformException e) {
            throw new RuntimeException(e);
        }
    }

    protected Specification<TSource> rewriteSpecification(Specification<TSource> specification) {
        return specification;
    }

    @Override
    public List<Map<String, Object>> analyze(List<String> dimensions, List<String> facts, Collection<Map.Entry<String, Boolean>> order, Specification<TSource> filter, Integer limit, Integer offset) {
        ArrayList<String> usedDimensions = new ArrayList<String>();
        ArrayList<String> usedFacts = new ArrayList<String>();
        LinkedHashMap<String, Boolean> customOrder = new LinkedHashMap<String, Boolean>();
        if (dimensions != null) {
            usedDimensions.addAll(dimensions);
        }
        if (facts != null) {
            usedFacts.addAll(facts);
        }
        if (order != null) {
            for (Map.Entry<String, Boolean> o : order) {
                if (o.getKey() == null) continue;
                customOrder.put(o.getKey(), o.getValue());
            }
        }
        this.validateInput(usedDimensions, usedFacts, customOrder.keySet());
        StringBuilder sb = new StringBuilder();
        String alias = filter != null ? this.getLambdaAlias(filter) : "_it";
        sb.append("SELECT ");
        for (String d : usedDimensions) {
            sb.append(this.cubeDimensions.get(d).apply(alias)).append(" AS \"").append(d).append("\", ");
        }
        for (String f : usedFacts) {
            sb.append(this.cubeFacts.get(f).apply(alias)).append(" AS \"").append(f).append("\", ");
        }
        sb.setLength(sb.length() - 2);
        sb.append('\n');
        sb.append("FROM ").append(this.getSource()).append(" \"").append(alias).append("\"");
        sb.append('\n');
        SelectFromWhere<TSource> sfw = null;
        LambdaInfo lambdaInfo = null;
        if (filter != null && (sfw = this.applyTransformWithLambda(alias, lambdaInfo = LambdaInfo.analyze(this.rewriteSpecification(filter), 0, true))) != null && sfw.generateWhere("\"" + alias + "\"")) {
            sb.append("WHERE\n");
            sb.append(sfw.getQueryString());
        }
        sb.append('\n');
        if (!usedDimensions.isEmpty()) {
            sb.append("GROUP BY ");
            for (String string : usedDimensions) {
                sb.append(this.cubeDimensions.get(string).apply(alias));
                sb.append(", ");
            }
            sb.setLength(sb.length() - 2);
            sb.append('\n');
        }
        if (!customOrder.isEmpty()) {
            sb.append("ORDER BY ");
            for (Map.Entry entry : customOrder.entrySet()) {
                sb.append("\"").append((String)entry.getKey()).append("\" ").append((Boolean)entry.getValue() != false ? "ASC" : "DESC");
                sb.append(", ");
            }
            sb.setLength(sb.length() - 2);
        }
        if (limit != null) {
            sb.append("LIMIT ").append(limit).append('\n');
        }
        if (offset != null) {
            sb.append("OFFSET ").append(offset).append('\n');
        }
        Connection connection = this.getConnection();
        ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
        try (PreparedStatement ps = connection.prepareStatement(sb.toString());){
            int i;
            if (sfw != null) {
                RevenjQueryComposer.fillQueryParameters(connection, this.locator, ps, sfw.getQueryParameters(), Collections.singletonList(lambdaInfo));
            }
            ResultSet rs = ps.executeQuery();
            int columns = rs.getMetaData().getColumnCount();
            String[] columnNames = new String[columns];
            for (i = 0; i < usedDimensions.size(); ++i) {
                columnNames[i] = (String)usedDimensions.get(i);
            }
            for (i = 0; i < usedFacts.size(); ++i) {
                columnNames[usedDimensions.size() + i] = (String)usedFacts.get(i);
            }
            while (rs.next()) {
                LinkedHashMap<String, Object> item = new LinkedHashMap<String, Object>();
                for (int i2 = 0; i2 < columns; ++i2) {
                    item.put(columnNames[i2], rs.getObject(1 + i2));
                }
                arrayList.add(item);
            }
            rs.close();
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
        return arrayList;
    }
}

