/*
 * Decompiled with CFR 0.152.
 */
package org.revenj.postgres.converters;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.revenj.postgres.PostgresBuffer;
import org.revenj.postgres.PostgresReader;
import org.revenj.postgres.PostgresWriter;
import org.revenj.postgres.converters.NumberConverter;
import org.revenj.postgres.converters.PostgresTuple;
import org.revenj.postgres.converters.ValueTuple;

public abstract class LongConverter {
    private static final PostgresTuple MIN_TUPLE = new ValueTuple("-9223372036854775808", false, false);

    public static void serializeURI(PostgresBuffer sw, long value) throws IOException {
        if (value == Long.MIN_VALUE) {
            sw.addToBuffer("-9223372036854775808");
        } else {
            int offset = NumberConverter.serialize(value, sw.getTempBuffer());
            sw.addToBuffer(sw.getTempBuffer(), offset, 21);
        }
    }

    public static void serializeURI(PostgresBuffer sw, Long value) throws IOException {
        if (value == null) {
            return;
        }
        LongConverter.serializeURI(sw, (long)value);
    }

    public static Long parseNullable(PostgresReader reader) {
        int cur = reader.read();
        if (cur == 44 || cur == 41) {
            return null;
        }
        return LongConverter.parseLong(reader, cur, ')');
    }

    public static long parse(PostgresReader reader) {
        int cur = reader.read();
        if (cur == 44 || cur == 41) {
            return 0L;
        }
        return LongConverter.parseLong(reader, cur, ')');
    }

    private static long parseLong(PostgresReader reader, int cur, char matchEnd) {
        long res = 0L;
        if (cur == 45) {
            cur = reader.read();
            do {
                res = (res << 3) + (res << 1) - (long)(cur - 48);
            } while ((cur = reader.read()) != -1 && cur != 44 && cur != matchEnd);
        } else {
            do {
                res = (res << 3) + (res << 1) + (long)(cur - 48);
            } while ((cur = reader.read()) != -1 && cur != 44 && cur != matchEnd);
        }
        return res;
    }

    public static List<Long> parseCollection(PostgresReader reader, int context, boolean allowNulls) {
        boolean escaped;
        int cur = reader.read();
        if (cur == 44 || cur == 41) {
            return null;
        }
        boolean bl = escaped = cur != 123;
        if (escaped) {
            reader.read(context);
        }
        if ((cur = reader.peek()) == 125) {
            if (escaped) {
                reader.read(context + 2);
            } else {
                reader.read(2);
            }
            return new ArrayList<Long>(0);
        }
        Long defaultValue = allowNulls ? null : Long.valueOf(0L);
        ArrayList<Long> list = new ArrayList<Long>();
        do {
            if ((cur = reader.read()) == 78) {
                list.add(defaultValue);
                cur = reader.read(4);
                continue;
            }
            list.add(LongConverter.parseLong(reader, cur, '}'));
            cur = reader.last();
        } while (cur == 44);
        if (escaped) {
            reader.read(context + 1);
        } else {
            reader.read();
        }
        return list;
    }

    public static PostgresTuple toTuple(Long value) {
        return value == null ? null : LongConverter.toTuple((long)value);
    }

    public static PostgresTuple toTuple(long value) {
        if (value == Long.MIN_VALUE) {
            return MIN_TUPLE;
        }
        return new LongTuple(value);
    }

    static class LongTuple
    extends PostgresTuple {
        private final long value;

        public LongTuple(long value) {
            this.value = value;
        }

        @Override
        public boolean mustEscapeRecord() {
            return false;
        }

        @Override
        public boolean mustEscapeArray() {
            return false;
        }

        @Override
        public void insertRecord(PostgresWriter sw, String escaping, PostgresTuple.Mapping mappings) {
            int offset = NumberConverter.serialize(this.value, sw.tmp);
            sw.write(sw.tmp, offset, 21);
        }

        @Override
        public String buildTuple(boolean quote) {
            return Long.toString(this.value);
        }
    }
}

