/*
 * Decompiled with CFR 0.152.
 */
package org.revenj.postgres.converters;

import java.util.concurrent.ConcurrentHashMap;
import org.revenj.postgres.PostgresWriter;

public abstract class PostgresTuple {
    private static final ConcurrentHashMap<String, String> QUOTE_ESCAPE = new ConcurrentHashMap();
    private static final String[] SLASHES = new String[20];

    abstract boolean mustEscapeRecord();

    abstract boolean mustEscapeArray();

    abstract void insertRecord(PostgresWriter var1, String var2, Mapping var3);

    void insertArray(PostgresWriter writer, String escaping, Mapping mappings) {
        this.insertRecord(writer, escaping, mappings);
    }

    public void buildTuple(PostgresWriter sw, boolean quote) {
        if (quote) {
            sw.write('\'');
            this.insertRecord(sw, "", PostgresTuple::escapeQuote);
            sw.write('\'');
        } else {
            this.insertRecord(sw, "", null);
        }
    }

    public String buildTuple(boolean quote) {
        try (PostgresWriter sw = PostgresWriter.create();){
            this.buildTuple(sw, quote);
            String string = sw.toString();
            return string;
        }
    }

    static void escapeQuote(PostgresWriter sw, char c) {
        if (c == '\'') {
            sw.write('\'');
        }
        sw.write(c);
    }

    static void escapeBulkCopy(PostgresWriter sw, char c) {
        switch (c) {
            case '\\': {
                sw.write("\\\\");
                break;
            }
            case '\t': {
                sw.write("\\t");
                break;
            }
            case '\n': {
                sw.write("\\n");
                break;
            }
            case '\r': {
                sw.write("\\r");
                break;
            }
            case '\u000b': {
                sw.write("\\v");
                break;
            }
            case '\b': {
                sw.write("\\b");
                break;
            }
            case '\f': {
                sw.write("\\f");
                break;
            }
            default: {
                sw.write(c);
            }
        }
    }

    public static String buildQuoteEscape(String escaping) {
        String result = QUOTE_ESCAPE.get(escaping);
        if (result != null) {
            return result;
        }
        StringBuilder sb = new StringBuilder();
        sb.append('\"');
        for (int j = escaping.length() - 1; j >= 0; --j) {
            if (escaping.charAt(j) == '1') {
                int len = sb.length();
                for (int i = 0; i < len; ++i) {
                    sb.insert(i * 2, sb.charAt(i * 2));
                }
                continue;
            }
            sb = new StringBuilder(sb.toString().replace("\\", "\\\\").replace("\"", "\\\""));
        }
        result = sb.toString();
        QUOTE_ESCAPE.put(escaping, result);
        return result;
    }

    public static String buildSlashEscape(int len) {
        if (len < SLASHES.length) {
            return SLASHES[len];
        }
        return new String(new char[1 << len]).replace('\u0000', '\\');
    }

    static {
        for (int i = 0; i < SLASHES.length; ++i) {
            PostgresTuple.SLASHES[i] = new String(new char[1 << i]).replace('\u0000', '\\');
        }
    }

    static interface Mapping {
        public void map(PostgresWriter var1, char var2);
    }
}

