/*
 * Decompiled with CFR 0.152.
 */
package org.revenj.postgres.converters;

import org.revenj.postgres.PostgresWriter;
import org.revenj.postgres.converters.PostgresTuple;

public class RecordTuple
extends PostgresTuple {
    public static final PostgresTuple EMPTY = new EmptyRecordTuple();
    public static final PostgresTuple NULL = new NullTuple();
    private final PostgresTuple[] properties;

    RecordTuple(PostgresTuple[] properties) {
        this.properties = properties;
    }

    public static PostgresTuple from(PostgresTuple[] properties) {
        if (properties == null) {
            return NULL;
        }
        if (properties.length == 0) {
            return EMPTY;
        }
        return new RecordTuple(properties);
    }

    @Override
    public boolean mustEscapeRecord() {
        return true;
    }

    @Override
    public boolean mustEscapeArray() {
        return true;
    }

    @Override
    public String buildTuple(boolean quote) {
        PostgresWriter sw = new PostgresWriter();
        PostgresTuple.Mapping mappings = null;
        if (quote) {
            mappings = PostgresTuple::escapeQuote;
            sw.write('\'');
        }
        sw.write('(');
        PostgresTuple p = this.properties[0];
        if (p != null) {
            if (p.mustEscapeRecord()) {
                sw.write('\"');
                p.insertRecord(sw, "1", mappings);
                sw.write('\"');
            } else {
                p.insertRecord(sw, "", mappings);
            }
        }
        for (int i = 1; i < this.properties.length; ++i) {
            sw.write(',');
            p = this.properties[i];
            if (p == null) continue;
            if (p.mustEscapeRecord()) {
                sw.write('\"');
                p.insertRecord(sw, "1", mappings);
                sw.write('\"');
                continue;
            }
            p.insertRecord(sw, "", mappings);
        }
        sw.write(')');
        if (quote) {
            sw.write('\'');
        }
        return sw.toString();
    }

    @Override
    public void insertRecord(PostgresWriter sw, String escaping, PostgresTuple.Mapping mappings) {
        sw.write('(');
        String newEscaping = escaping + '1';
        String quote = null;
        PostgresTuple p = this.properties[0];
        if (p != null) {
            if (p.mustEscapeRecord()) {
                int x;
                quote = RecordTuple.buildQuoteEscape(escaping);
                if (mappings != null) {
                    for (x = 0; x < quote.length(); ++x) {
                        mappings.map(sw, quote.charAt(x));
                    }
                } else {
                    sw.write(quote);
                }
                p.insertRecord(sw, newEscaping, mappings);
                if (mappings != null) {
                    for (x = 0; x < quote.length(); ++x) {
                        mappings.map(sw, quote.charAt(x));
                    }
                } else {
                    sw.write(quote);
                }
            } else {
                p.insertRecord(sw, escaping, mappings);
            }
        }
        for (int i = 1; i < this.properties.length; ++i) {
            sw.write(',');
            p = this.properties[i];
            if (p == null) continue;
            if (p.mustEscapeRecord()) {
                int x;
                String string = quote = quote != null ? quote : RecordTuple.buildQuoteEscape(escaping);
                if (mappings != null) {
                    for (x = 0; x < quote.length(); ++x) {
                        mappings.map(sw, quote.charAt(x));
                    }
                } else {
                    sw.write(quote);
                }
                p.insertRecord(sw, newEscaping, mappings);
                if (mappings != null) {
                    for (x = 0; x < quote.length(); ++x) {
                        mappings.map(sw, quote.charAt(x));
                    }
                    continue;
                }
                sw.write(quote);
                continue;
            }
            p.insertRecord(sw, escaping, mappings);
        }
        sw.write(')');
    }

    static class NullTuple
    extends PostgresTuple {
        NullTuple() {
        }

        @Override
        public boolean mustEscapeRecord() {
            return false;
        }

        @Override
        public boolean mustEscapeArray() {
            return false;
        }

        @Override
        public void insertRecord(PostgresWriter sw, String escaping, PostgresTuple.Mapping mappings) {
        }

        @Override
        public void insertArray(PostgresWriter sw, String escaping, PostgresTuple.Mapping mappings) {
            sw.write("NULL");
        }

        @Override
        public String buildTuple(boolean quote) {
            return "NULL";
        }
    }

    static class EmptyRecordTuple
    extends PostgresTuple {
        EmptyRecordTuple() {
        }

        @Override
        public boolean mustEscapeRecord() {
            return true;
        }

        @Override
        public boolean mustEscapeArray() {
            return false;
        }

        @Override
        public void insertRecord(PostgresWriter sw, String escaping, PostgresTuple.Mapping mappings) {
            sw.write("()");
        }

        @Override
        public void insertArray(PostgresWriter sw, String escaping, PostgresTuple.Mapping mappings) {
            sw.write("()");
        }

        @Override
        public String buildTuple(boolean quote) {
            return quote ? "'()'" : "()";
        }
    }
}

