/*
 * Decompiled with CFR 0.152.
 */
package org.revenj.postgres.jinq;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.revenj.postgres.jinq.jpqlquery.JinqPostgresQuery;

public final class RevenjQueryComposerCache {
    private final Map<CacheKey, Optional<JinqPostgresQuery<?>>> cachedQueryTransforms = new HashMap();
    private final Map<String, Optional<JinqPostgresQuery<?>>> cachedFindAllEntities = new HashMap();

    public synchronized Optional<JinqPostgresQuery<?>> findInCache(JinqPostgresQuery<?> base, String transformationType, String[] lambdaSources) {
        return this.cacheQuery(base, transformationType, lambdaSources, null);
    }

    public synchronized Optional<JinqPostgresQuery<?>> cacheQuery(JinqPostgresQuery<?> base, String transformationType, String[] lambdaSources, Optional<JinqPostgresQuery<?>> resultingQuery) {
        CacheKey key = new CacheKey();
        key.transformationType = transformationType;
        key.baseQuery = base;
        if (lambdaSources != null) {
            key.lambdaSources = Arrays.copyOf(lambdaSources, lambdaSources.length);
        }
        if (this.cachedQueryTransforms.containsKey(key)) {
            return this.cachedQueryTransforms.get(key);
        }
        if (resultingQuery != null) {
            this.cachedQueryTransforms.put(key, resultingQuery);
        }
        return resultingQuery;
    }

    public synchronized Optional<JinqPostgresQuery<?>> findCachedFindAll(String dataSource) {
        return this.cacheFindAll(dataSource, null);
    }

    public synchronized Optional<JinqPostgresQuery<?>> cacheFindAll(String dataSource, Optional<JinqPostgresQuery<?>> queryToCache) {
        if (this.cachedFindAllEntities.containsKey(dataSource)) {
            return this.cachedFindAllEntities.get(dataSource);
        }
        if (queryToCache != null) {
            this.cachedFindAllEntities.put(dataSource, queryToCache);
        }
        return queryToCache;
    }

    private static class CacheKey {
        String transformationType;
        JinqPostgresQuery<?> baseQuery;
        String[] lambdaSources;

        private CacheKey() {
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.baseQuery == null ? 0 : this.baseQuery.hashCode());
            result = 31 * result + Arrays.hashCode(this.lambdaSources);
            result = 31 * result + (this.transformationType == null ? 0 : this.transformationType.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CacheKey other = (CacheKey)obj;
            if (this.baseQuery == null ? other.baseQuery != null : !this.baseQuery.equals(other.baseQuery)) {
                return false;
            }
            if (!Arrays.equals(this.lambdaSources, other.lambdaSources)) {
                return false;
            }
            return !(this.transformationType == null ? other.transformationType != null : !this.transformationType.equals(other.transformationType));
        }
    }
}

