/*
 * Decompiled with CFR 0.152.
 */
package org.revenj.postgres.jinq.transform;

import ch.epfl.labos.iu.orm.queryll2.path.Annotations;
import ch.epfl.labos.iu.orm.queryll2.symbolic.TypedValue;
import ch.epfl.labos.iu.orm.queryll2.symbolic.TypedValueVisitorException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jinq.rebased.org.objectweb.asm.Type;
import org.revenj.postgres.jinq.jpqlquery.ColumnExpressions;
import org.revenj.postgres.jinq.jpqlquery.JinqPostgresQuery;
import org.revenj.postgres.jinq.jpqlquery.ParameterAsQuery;
import org.revenj.postgres.jinq.jpqlquery.ParameterExpression;
import org.revenj.postgres.jinq.jpqlquery.ParameterFieldExpression;
import org.revenj.postgres.jinq.jpqlquery.SimpleRowReader;
import org.revenj.postgres.jinq.transform.LambdaAnalysis;
import org.revenj.postgres.jinq.transform.MetamodelUtil;
import org.revenj.postgres.jinq.transform.SymbExArgumentHandler;

public class LambdaParameterArgumentHandler
implements SymbExArgumentHandler {
    LambdaAnalysis lambda;
    MetamodelUtil metamodel;
    boolean hasInQueryStreamSource;
    SymbExArgumentHandler parentArgumentScope;
    final int numLambdaCapturedArgs;
    final int numLambdaArgs;
    public static final Set<Type> ALLOWED_QUERY_PARAMETER_TYPES = new HashSet<Type>();

    public LambdaParameterArgumentHandler(LambdaAnalysis lambda, MetamodelUtil metamodel, SymbExArgumentHandler parentArgumentScope, boolean hasInQueryStreamSource) {
        this.lambda = lambda;
        this.metamodel = metamodel;
        this.hasInQueryStreamSource = hasInQueryStreamSource;
        this.numLambdaCapturedArgs = lambda.getNumCapturedArgs();
        this.numLambdaArgs = lambda.getNumLambdaArgs();
        this.parentArgumentScope = parentArgumentScope;
    }

    protected ColumnExpressions<?> handleLambdaArg(int argIndex, Type argType) throws TypedValueVisitorException {
        throw new TypedValueVisitorException("Unhandled lambda arguments");
    }

    protected ColumnExpressions<?> handleIndirectLambdaArg(int argIndex, Type argType) throws TypedValueVisitorException {
        TypedValue paramVal = this.lambda.getIndirectCapturedArg(argIndex);
        if (paramVal instanceof TypedValue.ArgValue) {
            TypedValue.ArgValue paramArg = (TypedValue.ArgValue)paramVal;
            int parentArgIndex = paramArg.getIndex();
            if (this.parentArgumentScope == null) {
                throw new TypedValueVisitorException("Cannot find a parent scope to determine how to access as sublambda's parent parameters.");
            }
            return this.parentArgumentScope.handleArg(parentArgIndex, argType);
        }
        throw new TypedValueVisitorException("Jinq can only passthrough parent lambda parameters directly to sub-lambdas. Sublambdas cannot take parameters that involve computation.");
    }

    protected ColumnExpressions<?> getAndValidateArg(int argIndex, Type argType) throws TypedValueVisitorException {
        try {
            if (!ALLOWED_QUERY_PARAMETER_TYPES.contains(argType) && (Annotations.asmTypeToClass((Type)argType).isPrimitive() || this.metamodel.getEnumName(argType.getInternalName()) == null && !this.metamodel.isKnownManagedType(argType.getClassName()))) {
                throw new TypedValueVisitorException("Accessing a field with unhandled type");
            }
        }
        catch (ClassNotFoundException e) {
            throw new TypedValueVisitorException("Accessing a field with unhandled type", (Throwable)e);
        }
        return ColumnExpressions.singleColumn(SimpleRowReader.READER, new ParameterExpression(this.lambda.getLambdaIndex(), argIndex));
    }

    protected JinqPostgresQuery<?> handleIndirectLambdaSubQueryArg(int argIndex, Type argType) throws TypedValueVisitorException {
        TypedValue paramVal = this.lambda.getIndirectCapturedArg(argIndex);
        if (paramVal instanceof TypedValue.ArgValue) {
            TypedValue.ArgValue paramArg = (TypedValue.ArgValue)paramVal;
            int parentArgIndex = paramArg.getIndex();
            if (this.parentArgumentScope == null) {
                throw new TypedValueVisitorException("Cannot find a parent scope to determine how to access as sublambda's parent parameters.");
            }
            return this.parentArgumentScope.handleSubQueryArg(parentArgIndex, argType);
        }
        throw new TypedValueVisitorException("Jinq can only passthrough parent lambda parameters directly to sub-lambdas. Sublambdas cannot take parameters that involve computation.");
    }

    protected JinqPostgresQuery<?> getAndValidateSubQueryArg(int argIndex, Type argType) throws TypedValueVisitorException {
        try {
            if (!Collection.class.isAssignableFrom(Annotations.asmTypeToClass((Type)argType))) {
                throw new TypedValueVisitorException("Using an unhandled type as a subquery parameter");
            }
        }
        catch (ClassNotFoundException e) {
            throw new TypedValueVisitorException("Cannot find the class of the object being used as a parameter.");
        }
        ParameterAsQuery query = new ParameterAsQuery();
        query.cols = ColumnExpressions.singleColumn(SimpleRowReader.READER, new ParameterExpression(this.lambda.getLambdaIndex(), argIndex));
        return query;
    }

    @Override
    public ColumnExpressions<?> handleArg(int argIndex, Type argType) throws TypedValueVisitorException {
        if (argIndex < this.numLambdaCapturedArgs) {
            if (this.lambda == null) {
                throw new TypedValueVisitorException("No lambda source was supplied where parameters can be extracted");
            }
            if (this.lambda.usesIndirectArgs()) {
                return this.handleIndirectLambdaArg(argIndex, argType);
            }
            return this.getAndValidateArg(argIndex, argType);
        }
        if (this.checkIsInQueryStreamSource(argIndex)) {
            throw new TypedValueVisitorException("Using InQueryStreamSource as data");
        }
        return this.handleLambdaArg(argIndex - this.numLambdaCapturedArgs, argType);
    }

    protected JinqPostgresQuery<?> handleLambdaSubQueryArg(int argIndex, Type argType) throws TypedValueVisitorException {
        throw new TypedValueVisitorException("Unhandled lambda subquery arguments");
    }

    @Override
    public JinqPostgresQuery<?> handleSubQueryArg(int argIndex, Type argType) throws TypedValueVisitorException {
        if (argIndex < this.numLambdaCapturedArgs) {
            if (this.lambda == null) {
                throw new TypedValueVisitorException("No lambda source was supplied where parameters can be extracted");
            }
            if (this.lambda.usesIndirectArgs()) {
                return this.handleIndirectLambdaSubQueryArg(argIndex, argType);
            }
            return this.getAndValidateSubQueryArg(argIndex, argType);
        }
        if (!this.checkIsInQueryStreamSource(argIndex)) {
            return this.handleLambdaSubQueryArg(argIndex - this.numLambdaCapturedArgs, argType);
        }
        throw new TypedValueVisitorException("Cannot use parameters as a subquery");
    }

    protected ColumnExpressions<?> handleIndirectThisFieldRead(String name, Type argType) throws TypedValueVisitorException {
        TypedValue paramVal = this.lambda.getIndirectFieldValue(name);
        if (paramVal instanceof TypedValue.ArgValue) {
            TypedValue.ArgValue paramArg = (TypedValue.ArgValue)paramVal;
            int parentArgIndex = paramArg.getIndex();
            if (this.parentArgumentScope == null) {
                throw new TypedValueVisitorException("Cannot find a parent scope to determine how to access as sublambda's parent parameters.");
            }
            return this.parentArgumentScope.handleArg(parentArgIndex, argType);
        }
        if (paramVal instanceof TypedValue.GetFieldValue) {
            TypedValue.GetFieldValue paramArg = (TypedValue.GetFieldValue)paramVal;
            String parentFieldName = paramArg.name;
            if (this.parentArgumentScope == null) {
                throw new TypedValueVisitorException("Cannot find a parent scope to determine how to access as sublambda's parent parameters.");
            }
            return this.parentArgumentScope.handleThisFieldRead(parentFieldName, argType);
        }
        throw new TypedValueVisitorException("Jinq can only passthrough parent lambda parameters directly to sub-lambdas. Sublambdas cannot take parameters that involve computation.");
    }

    @Override
    public ColumnExpressions<?> handleThisFieldRead(String name, Type argType) throws TypedValueVisitorException {
        if (this.lambda.usesParametersAsFields()) {
            if (this.lambda.usesIndirectFields()) {
                return this.handleIndirectThisFieldRead(name, argType);
            }
            if (!ALLOWED_QUERY_PARAMETER_TYPES.contains(argType) && this.metamodel.getEnumName(argType.getInternalName()) == null && !this.metamodel.isKnownManagedType(argType.getClassName())) {
                throw new TypedValueVisitorException("Accessing a field with unhandled type");
            }
            return ColumnExpressions.singleColumn(SimpleRowReader.READER, new ParameterFieldExpression(this.lambda.getLambdaIndex(), name));
        }
        throw new TypedValueVisitorException("Cannot read fields of this lambda");
    }

    @Override
    public JinqPostgresQuery<?> handleSubQueryThisFieldRead(String name, Type argType) throws TypedValueVisitorException {
        throw new TypedValueVisitorException("Cannot read fields of this lambda for a subquery");
    }

    @Override
    public boolean checkIsInQueryStreamSource(int argIndex) {
        return this.hasInQueryStreamSource && argIndex == this.numLambdaArgs - 1;
    }

    static {
        ALLOWED_QUERY_PARAMETER_TYPES.add(Type.INT_TYPE);
        ALLOWED_QUERY_PARAMETER_TYPES.add(Type.DOUBLE_TYPE);
        ALLOWED_QUERY_PARAMETER_TYPES.add(Type.FLOAT_TYPE);
        ALLOWED_QUERY_PARAMETER_TYPES.add(Type.LONG_TYPE);
        ALLOWED_QUERY_PARAMETER_TYPES.add(Type.BOOLEAN_TYPE);
        ALLOWED_QUERY_PARAMETER_TYPES.add(Type.getObjectType((String)"java/lang/Integer"));
        ALLOWED_QUERY_PARAMETER_TYPES.add(Type.getObjectType((String)"java/lang/Double"));
        ALLOWED_QUERY_PARAMETER_TYPES.add(Type.getObjectType((String)"java/lang/Float"));
        ALLOWED_QUERY_PARAMETER_TYPES.add(Type.getObjectType((String)"java/lang/Long"));
        ALLOWED_QUERY_PARAMETER_TYPES.add(Type.getObjectType((String)"java/lang/Boolean"));
        ALLOWED_QUERY_PARAMETER_TYPES.add(Type.getObjectType((String)"java/lang/String"));
        ALLOWED_QUERY_PARAMETER_TYPES.add(Type.getObjectType((String)"java/time/LocalDate"));
        ALLOWED_QUERY_PARAMETER_TYPES.add(Type.getObjectType((String)"java/time/LocalDateTime"));
        ALLOWED_QUERY_PARAMETER_TYPES.add(Type.getObjectType((String)"java/time/OffsetDateTime"));
        ALLOWED_QUERY_PARAMETER_TYPES.add(Type.getObjectType((String)"java/sql/Date"));
        ALLOWED_QUERY_PARAMETER_TYPES.add(Type.getObjectType((String)"java/sql/Time"));
        ALLOWED_QUERY_PARAMETER_TYPES.add(Type.getObjectType((String)"java/sql/Timestamp"));
        ALLOWED_QUERY_PARAMETER_TYPES.add(Type.getObjectType((String)"java/util/Date"));
        ALLOWED_QUERY_PARAMETER_TYPES.add(Type.getObjectType((String)"java/util/Calendar"));
        ALLOWED_QUERY_PARAMETER_TYPES.add(Type.getObjectType((String)"java/util/UUID"));
        ALLOWED_QUERY_PARAMETER_TYPES.add(Type.getObjectType((String)"java/math/BigDecimal"));
        ALLOWED_QUERY_PARAMETER_TYPES.add(Type.getObjectType((String)"java/math/BigInteger"));
    }
}

