/*
 * Decompiled with CFR 0.152.
 */
package org.revenj.postgres.jinq.transform;

import ch.epfl.labos.iu.orm.queryll2.path.TransformationClassAnalyzer;
import ch.epfl.labos.iu.orm.queryll2.symbolic.MethodSignature;
import ch.epfl.labos.iu.orm.queryll2.symbolic.TypedValue;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jinq.rebased.org.objectweb.asm.Type;
import org.revenj.postgres.jinq.transform.MethodChecker;

public abstract class MetamodelUtil {
    private final Set<Class<?>> safeMethodAnnotations;
    protected final Map<MethodSignature, MetamodelUtilAttribute> fieldMethods;
    protected final Map<MethodSignature, MetamodelUtilAttribute> nLinkMethods;
    protected final Set<MethodSignature> safeMethods;
    protected final Set<MethodSignature> safeStaticMethods;
    protected final Map<String, String> enums;
    protected final Map<MethodSignature, String> statics;
    protected final Set<String> knownEmbeddedtypes = new HashSet<String>();
    protected final Map<MethodSignature, TypedValue.ComparisonValue.ComparisonOp> comparisonMethods;
    protected final Map<MethodSignature, TypedValue.ComparisonValue.ComparisonOp> comparisonMethodsWithObjectEquals;
    protected final Map<MethodSignature, TypedValue.ComparisonValue.ComparisonOp> staticComparisonMethods;
    protected final Map<MethodSignature, TypedValue.ComparisonValue.ComparisonOp> staticComparisonMethodsWithObjectEquals;
    public static final Map<MethodSignature, Integer> TUPLE_ACCESSORS = new HashMap<MethodSignature, Integer>();
    public static final MethodSignature inQueryStream;

    public MetamodelUtil() {
        this.enums = new HashMap<String, String>();
        this.statics = new HashMap<MethodSignature, String>();
        this.comparisonMethods = new HashMap<MethodSignature, TypedValue.ComparisonValue.ComparisonOp>();
        this.staticComparisonMethods = new HashMap<MethodSignature, TypedValue.ComparisonValue.ComparisonOp>();
        this.safeMethodAnnotations = new HashSet();
        this.safeMethodAnnotations.addAll(TransformationClassAnalyzer.SafeMethodAnnotations);
        this.safeMethods = new HashSet<MethodSignature>();
        this.safeMethods.addAll(TransformationClassAnalyzer.KnownSafeMethods);
        this.safeMethods.add(TransformationClassAnalyzer.integerIntValue);
        this.safeMethods.add(TransformationClassAnalyzer.longLongValue);
        this.safeMethods.add(TransformationClassAnalyzer.floatFloatValue);
        this.safeMethods.add(TransformationClassAnalyzer.doubleDoubleValue);
        this.safeMethods.add(TransformationClassAnalyzer.booleanBooleanValue);
        this.safeMethods.add(inQueryStream);
        this.safeStaticMethods = new HashSet<MethodSignature>();
        this.safeStaticMethods.addAll(TransformationClassAnalyzer.KnownSafeStaticMethods);
        this.safeStaticMethods.add(TransformationClassAnalyzer.integerValueOf);
        this.safeStaticMethods.add(TransformationClassAnalyzer.longValueOf);
        this.safeStaticMethods.add(TransformationClassAnalyzer.doubleValueOf);
        this.safeStaticMethods.add(TransformationClassAnalyzer.floatValueOf);
        this.safeStaticMethods.add(TransformationClassAnalyzer.booleanValueOf);
        this.fieldMethods = new HashMap<MethodSignature, MetamodelUtilAttribute>();
        this.nLinkMethods = new HashMap<MethodSignature, MetamodelUtilAttribute>();
        this.comparisonMethodsWithObjectEquals = new HashMap<MethodSignature, TypedValue.ComparisonValue.ComparisonOp>();
        this.comparisonMethodsWithObjectEquals.put(MethodChecker.objectEquals, TypedValue.ComparisonValue.ComparisonOp.eq);
        this.staticComparisonMethodsWithObjectEquals = new HashMap<MethodSignature, TypedValue.ComparisonValue.ComparisonOp>();
        this.staticComparisonMethodsWithObjectEquals.put(MethodChecker.objectsEquals, TypedValue.ComparisonValue.ComparisonOp.eq);
    }

    protected void addProperty(Method method, String property) {
        MethodSignature signature = MethodSignature.fromMethod((Method)method);
        this.fieldMethods.put(signature, new MetamodelUtilAttribute(property, false));
        this.safeMethods.add(signature);
    }

    protected void addStatic(Method method, String function) {
        MethodSignature signature = MethodSignature.fromMethod((Method)method);
        this.statics.put(signature, function);
        this.safeStaticMethods.add(signature);
    }

    private void insertNLinkMethod(String className, String methodName, String returnType, MetamodelUtilAttribute pluralAttribute) {
        MethodSignature methodSig = new MethodSignature(className, methodName, returnType);
        this.nLinkMethods.put(methodSig, pluralAttribute);
    }

    public void registerEnum(Class<?> enumClass, String dbName) {
        String enumTypeName = Type.getInternalName(enumClass);
        this.enums.put(enumTypeName, dbName);
        MethodSignature eqMethod = new MethodSignature(enumTypeName, "equals", "(Ljava/lang/Object;)Z");
        this.comparisonMethods.put(eqMethod, TypedValue.ComparisonValue.ComparisonOp.eq);
        this.comparisonMethodsWithObjectEquals.put(eqMethod, TypedValue.ComparisonValue.ComparisonOp.eq);
        this.safeMethods.add(eqMethod);
    }

    public <U> boolean isKnownManagedType(String entityClassName) {
        return this.dataSourceNameFromClassName(entityClassName) != null || this.knownEmbeddedtypes.contains(entityClassName);
    }

    public abstract <U> String dataSourceNameFromClass(Class<U> var1);

    public abstract String dataSourceNameFromClassName(String var1);

    public boolean isSingularAttributeFieldMethod(MethodSignature sig) {
        return this.fieldMethods.containsKey(sig);
    }

    public String fieldMethodToFieldName(MethodSignature sig) {
        return this.fieldMethods.get((Object)sig).name;
    }

    public boolean isFieldMethodAssociationType(MethodSignature sig) {
        return this.fieldMethods.get((Object)sig).isAssociation;
    }

    public boolean isPluralAttributeLinkMethod(MethodSignature sig) {
        return this.nLinkMethods.containsKey(sig);
    }

    public String nLinkMethodToLinkName(MethodSignature sig) {
        return this.nLinkMethods.get((Object)sig).name;
    }

    public String getEnumName(String className) {
        return this.enums.get(className);
    }

    public Map<MethodSignature, TypedValue.ComparisonValue.ComparisonOp> getComparisonMethods(boolean withObjectEquals) {
        return withObjectEquals ? this.comparisonMethodsWithObjectEquals : this.comparisonMethods;
    }

    public Map<MethodSignature, TypedValue.ComparisonValue.ComparisonOp> getStaticComparisonMethods(boolean withObjectEquals) {
        return withObjectEquals ? this.staticComparisonMethodsWithObjectEquals : this.staticComparisonMethods;
    }

    public Set<Class<?>> getSafeMethodAnnotations() {
        return this.safeMethodAnnotations;
    }

    public Set<MethodSignature> getSafeMethods() {
        return this.safeMethods;
    }

    public Set<MethodSignature> getSafeStaticMethods() {
        return this.safeStaticMethods;
    }

    public MethodChecker getMethodChecker(boolean isObjectEqualsSafe, boolean isCollectionContainsSafe) {
        return new MethodChecker(this.getSafeMethodAnnotations(), this.getSafeMethods(), this.getSafeStaticMethods(), isObjectEqualsSafe, isCollectionContainsSafe);
    }

    static {
        TUPLE_ACCESSORS.put(TransformationClassAnalyzer.pairGetOne, 1);
        TUPLE_ACCESSORS.put(TransformationClassAnalyzer.pairGetTwo, 2);
        TUPLE_ACCESSORS.put(TransformationClassAnalyzer.tuple3GetOne, 1);
        TUPLE_ACCESSORS.put(TransformationClassAnalyzer.tuple3GetTwo, 2);
        TUPLE_ACCESSORS.put(TransformationClassAnalyzer.tuple3GetThree, 3);
        TUPLE_ACCESSORS.put(TransformationClassAnalyzer.tuple4GetOne, 1);
        TUPLE_ACCESSORS.put(TransformationClassAnalyzer.tuple4GetTwo, 2);
        TUPLE_ACCESSORS.put(TransformationClassAnalyzer.tuple4GetThree, 3);
        TUPLE_ACCESSORS.put(TransformationClassAnalyzer.tuple4GetFour, 4);
        TUPLE_ACCESSORS.put(TransformationClassAnalyzer.tuple5GetOne, 1);
        TUPLE_ACCESSORS.put(TransformationClassAnalyzer.tuple5GetTwo, 2);
        TUPLE_ACCESSORS.put(TransformationClassAnalyzer.tuple5GetThree, 3);
        TUPLE_ACCESSORS.put(TransformationClassAnalyzer.tuple5GetFour, 4);
        TUPLE_ACCESSORS.put(TransformationClassAnalyzer.tuple5GetFive, 5);
        TUPLE_ACCESSORS.put(TransformationClassAnalyzer.tuple6GetOne, 1);
        TUPLE_ACCESSORS.put(TransformationClassAnalyzer.tuple6GetTwo, 2);
        TUPLE_ACCESSORS.put(TransformationClassAnalyzer.tuple6GetThree, 3);
        TUPLE_ACCESSORS.put(TransformationClassAnalyzer.tuple6GetFour, 4);
        TUPLE_ACCESSORS.put(TransformationClassAnalyzer.tuple6GetFive, 5);
        TUPLE_ACCESSORS.put(TransformationClassAnalyzer.tuple6GetSix, 6);
        TUPLE_ACCESSORS.put(TransformationClassAnalyzer.tuple7GetOne, 1);
        TUPLE_ACCESSORS.put(TransformationClassAnalyzer.tuple7GetTwo, 2);
        TUPLE_ACCESSORS.put(TransformationClassAnalyzer.tuple7GetThree, 3);
        TUPLE_ACCESSORS.put(TransformationClassAnalyzer.tuple7GetFour, 4);
        TUPLE_ACCESSORS.put(TransformationClassAnalyzer.tuple7GetFive, 5);
        TUPLE_ACCESSORS.put(TransformationClassAnalyzer.tuple7GetSix, 6);
        TUPLE_ACCESSORS.put(TransformationClassAnalyzer.tuple7GetSeven, 7);
        TUPLE_ACCESSORS.put(TransformationClassAnalyzer.tuple8GetOne, 1);
        TUPLE_ACCESSORS.put(TransformationClassAnalyzer.tuple8GetTwo, 2);
        TUPLE_ACCESSORS.put(TransformationClassAnalyzer.tuple8GetThree, 3);
        TUPLE_ACCESSORS.put(TransformationClassAnalyzer.tuple8GetFour, 4);
        TUPLE_ACCESSORS.put(TransformationClassAnalyzer.tuple8GetFive, 5);
        TUPLE_ACCESSORS.put(TransformationClassAnalyzer.tuple8GetSix, 6);
        TUPLE_ACCESSORS.put(TransformationClassAnalyzer.tuple8GetSeven, 7);
        TUPLE_ACCESSORS.put(TransformationClassAnalyzer.tuple8GetEight, 8);
        inQueryStream = new MethodSignature("org/jinq/orm/stream/InQueryStreamSource", "stream", "(Ljava/lang/Class;)Lorg/jinq/orm/stream/JinqStream;");
    }

    class MetamodelUtilAttribute {
        public final String name;
        public final boolean isAssociation;

        public MetamodelUtilAttribute(String name, boolean isAssociation) {
            this.name = name;
            this.isAssociation = isAssociation;
        }
    }
}

