/*
 * Decompiled with CFR 0.152.
 */
package org.revenj;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Type;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import org.revenj.Utils;
import org.revenj.extensibility.PluginLoader;

final class ServicesPluginLoader
implements PluginLoader {
    private static final String PREFIX = "META-INF/services/";
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private final ClassLoader loader;

    ServicesPluginLoader(ClassLoader loader) {
        this.loader = loader != null ? loader : ClassLoader.getSystemClassLoader();
    }

    @Override
    public <T> List<Class<T>> find(Class<T> manifest, Type ... types) throws Exception {
        String fullName = types.length == 0 ? PREFIX + manifest.getName() : (types.length == 1 ? PREFIX + URLEncoder.encode(Utils.makeGenericType(manifest, types[0], new Type[0]).toString(), "UTF-8") : PREFIX + URLEncoder.encode(Utils.makeGenericType(manifest, types[0], (Type[])Arrays.stream(types).skip(1L).toArray(i -> new Type[types.length - 1])).toString(), "UTF-8"));
        Enumeration<URL> configs = this.loader.getResources(fullName);
        ArrayList<Class<T>> plugins = new ArrayList<Class<T>>();
        while (configs.hasMoreElements()) {
            URL url = configs.nextElement();
            this.lookupServices(manifest, url, plugins);
        }
        return plugins;
    }

    private <T> void lookupServices(Class<T> manifest, URL u, List<Class<T>> plugins) throws Exception {
        try (InputStream stream = u.openStream();
             BufferedReader reader = new BufferedReader(new InputStreamReader(stream, UTF8));){
            String line;
            while ((line = reader.readLine()) != null) {
                int n;
                int ci = line.indexOf(35);
                if (ci >= 0) {
                    line = line.substring(0, ci);
                }
                if ((n = (line = line.trim()).length()) == 0) continue;
                if (line.indexOf(32) >= 0 || line.indexOf(9) >= 0) {
                    throw new IOException("Invalid configuration for " + manifest + " in " + u);
                }
                int cp = line.codePointAt(0);
                if (!Character.isJavaIdentifierStart(cp)) {
                    throw new IOException("Invalid configuration for " + manifest + " in " + u);
                }
                for (int i = Character.charCount(cp); i < n; i += Character.charCount(cp)) {
                    cp = line.codePointAt(i);
                    if (Character.isJavaIdentifierPart(cp) || cp == 46) continue;
                    throw new IOException("Invalid configuration for " + manifest + " in " + u);
                }
                Class<?> service = this.loader.loadClass(line);
                plugins.add(service);
            }
        }
    }
}

