/*
 * Decompiled with CFR 0.152.
 */
package org.revenj.patterns;

import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.revenj.patterns.DataSource;
import org.revenj.patterns.Specification;

public interface Query<T extends DataSource> {
    public Query<T> filter(Specification<T> var1);

    public Query<T> skip(long var1);

    public Query<T> limit(long var1);

    public <V> Query<T> sortedBy(Compare<T, V> var1);

    public <V> Query<T> sortedDescendingBy(Compare<T, V> var1);

    public long count() throws IOException;

    public boolean anyMatch(Specification<? super T> var1) throws IOException;

    default public boolean any() throws IOException {
        return this.anyMatch(null);
    }

    public boolean allMatch(Specification<? super T> var1) throws IOException;

    public boolean noneMatch(Specification<? super T> var1) throws IOException;

    public Optional<T> findFirst() throws IOException;

    public Optional<T> findAny() throws IOException;

    public List<T> list() throws IOException;

    default public Stream<T> stream() throws IOException {
        return this.list().stream();
    }

    @FunctionalInterface
    public static interface Compare<U, V>
    extends Serializable {
        public V compare(U var1);
    }
}

