/*
 * Decompiled with CFR 0.152.
 */
package org.revenj.patterns;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.revenj.patterns.Identifiable;

public interface Repository<T extends Identifiable> {
    public List<T> find(String[] var1);

    default public List<T> find(Collection<String> uris) {
        return this.find(uris.toArray(new String[uris.size()]));
    }

    default public Optional<T> find(String uri) {
        List<T> result = this.find(new String[]{uri});
        return result.isEmpty() ? Optional.empty() : Optional.of(result.get(0));
    }
}

